#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import tkinter as tk
import tkinter.ttk				#Essential for ttk. commands
from tkinter import *			#Essential for root = Tk()

from sigil_bs4 import BeautifulSoup

import GenUtils					#Need centerWindow()

text_type = str

class cManualWordCheck:
	ManualFileName=''
	
	def __init__(self, parent):
		self.top = tk.Toplevel(parent)
		self.top.transient(parent)	#Ensure parent is shown below this dialog
		self.TextLines=[]
		self.LineCounter=0
		self.WordListCounter=0
		self.Wordlist=[]
		self.html=''
		self.chkword=''
		self.replace=''

	def loadWordList(self):
		try:
			f=open(cManualWordCheck.ManualFileName, 'r', encoding="utf-8")
		except IOError:
			self.top.withdraw()	#Hide the main window
			messagebox.showwarning('WARNING',"Could not load a file containing manual words for checking.\n\nYou need to install a valid file that contains words for checking\nor untick the box 'Do manual word check'.\n\nFor instructions on how to set up a file for this please see the manual.")
			return (True)	#FileNotLoaded value
		else:
			for line in f:
				line=line.strip("\n")	#strip newline from each line
				self.Wordlist.append(line)
			f.close()
			return (False)	#FileNotLoaded value

	def dlgCheckWords(self):
		"""
		Shows a dialog with the suspect word.
		The user needs to select an action in the combobox and then click the "Process text" button
		"""
		self.top.grab_set() #Make dialog box modal
		self.top.title("Check words") #Title for dialog box
		mainframe = tkinter.ttk.Frame(self.top, padding="15 15 12 12", relief=SUNKEN)
		mainframe.grid(column=0, row=0, sticky=(N, W, E, S))
		mainframe.columnconfigure(0, weight=1)
		mainframe.rowconfigure(0, weight=1)

		tk.Label(mainframe, text = "Check the highlighted word in the text shown", fg="blue").grid(column = 0, row=0, sticky = N)

		Scr = Scrollbar(mainframe)
		self.txtBox = Text(mainframe, height=10, width=70, exportselection=0, wrap=WORD)
		self.txtBox.grid(column = 0, row=3, sticky = N)
		self.txtBox.config(yscrollcommand=Scr.set)
		Scr.config(command=self.txtBox.yview)
		Scr.grid(column = 1, row=2, rowspan=2, sticky = (E,N,S))
		self.txtBox.tag_config("HILITE", background="yellow", foreground="blue")

		self.txtReplaceWord = StringVar()
		self.edit=ttk.Entry(mainframe, width=40, textvariable=self.txtReplaceWord)
		self.edit.grid(column = 0, row=10, sticky = N)

		tk.Label(mainframe, text = "").grid(column = 0, row=15, sticky = N)

		tk.Button(mainframe, text="Change word", command=self.changeWord, width = 20).grid(column=0, row=25, sticky=W)
		tk.Button(mainframe, text="Ignore word", command=self.NextLine, width = 20).grid(column=0, row=30, sticky=W)
		return

	def changeWord(self):
		#Called in response to clicking the button "Change word" in the main dialog
		tempLine=re.sub(r"\b"+self.chkword+r"\b",self.replace, self.TextLines[self.LineCounter])
		self.html=re.sub(re.escape(self.TextLines[self.LineCounter]), tempLine, self.html)
		self.NextLine()	#Get next line to process, if any
		return

	def GetNextWord(self):
		"""
		Called by NextLine() and checkWords()
		Calls getLines() to put all lines with this word in the list Wordlist[]
		"""
		if self.WordListCounter <len(self.Wordlist):	#Any more words to process?
			self.chkword, self.replace = self.Wordlist[self.WordListCounter].split("|") #Get them
			self.txtReplaceWord.set(self.replace)	#Put its replacement word in dialog box
			self.WordListCounter +=1
			self.getLines()							#Put all lines with this word in the list Wordlist[]
		else:
			self.WordListCounter=0
			if not self.html == self.html_orig: self.bk1.writefile(self.ID, self.html)	#If the text has changed then write the amended text to the book
			self.nextHTML()	#get next html file

	def processNextLine(self):
		"""
		Called by NextLine() - avoids too-deep recursion
		"""
		self.LineCounter +=1	#Increase number of lines processed
		if self.LineCounter <  len(self.TextLines):	#Are there any more lines to process?
			self.txtBox['state'] = 'normal'								#Allow writing to the textbox
			self.txtBox.delete('1.0', END)								#Yes - Clear textbox...
			self.txtBox.insert('1.0',self.TextLines[self.LineCounter])	#...and put next line in textbox
			wordStart = self.txtBox.search(r"\W"+self.chkword+r"\W", '1.0',  regexp=True)+ "+1c"  #This is a string
			wordEnd = self.txtBox.search("\W", wordStart + "+1c", regexp=True) #and so is this!
			self.txtBox.tag_add('HILITE', wordStart, wordEnd)
			self.txtBox['state'] = 'disabled'			#Disllow writing to the textbox

	def NextLine(self):
		#Get next line containing a potentially misspelt word from the list
		#Called by changeWord(), checkWords() and
		#in response to clicking the button "Ignore word" in the main dialog
		self.LineCounter +=1	#Increase number of lines processed
		if self.LineCounter <  len(self.TextLines):	#Are there any more lines to process?
			self.txtBox['state'] = 'normal'								#Allow writing to the textbox
			self.txtBox.delete('1.0', END)								#Yes - Clear textbox...
			self.txtBox.insert('1.0',self.TextLines[self.LineCounter])	#...and put next line in textbox
			wordStart = self.txtBox.search(r"\W"+self.chkword+r"\W", '1.0',  regexp=True)+ "+1c"  #This is a string
			wordEnd = self.txtBox.search("\W", wordStart + "+1c", regexp=True) #and so is this!
			self.txtBox.tag_add('HILITE', wordStart, wordEnd)
			self.txtBox['state'] = 'disabled'			#Disllow writing to the textbox
		else:	#All lines containing the current word processed
			self.GetNextWord()#Get next word, if it exists
			self.processNextLine()
		return

	def getLines(self):
		"""
		This method is called by checkWords() and GetNextWord()
		It parses the html file to find lines that contain potentially incorrect words
		It puts these lines into the list self.TextLines[] that is processed later
		"""
		self.TextLines=[]	#clear list
		self.LineCounter=0
		soup = BeautifulSoup(self.html, 'html.parser')
		text = soup.get_text()	# get text from html
		for lines in soup.stripped_strings:
			if re.search(r"\b"+self.chkword+r"\b",  lines):	#Find whole words only that match the word to be checked
				self.TextLines.append(lines)
		self.LineCounter=-1
		if len(self.TextLines)==0:	#If no lines with this word has been found
			self.GetNextWord()		#get the next word to check

	def nextHTML(self):
		"""
		This function gets the nxt html file that has been selected.
		If there are none it closes the dialog for this class.
		"""
		try:
			self.ID=next(self.iterateIDList)		#Load next ID in list
		except:
			self.top.destroy()	#No more fields to get - close dialog
		else:
			self.html = self.bk1.readfile(self.ID)		#Read the section into html
			if not isinstance(self.html, text_type):		#If the section is not str
				self.html = text_type(self.html, 'utf-8')		#then sets its type to 'utf-8'
			self.html_orig = self.html						#Copy the result to html_orig
			self.getLines()							#Put all lines with this word in the list Wordlist[]

	def checkWords(self,bk, IDlist):
		#This is the entry point for the class
		if self.loadWordList():	#if FileNotLoaded
			print("Could not open the file containing the list of manual words to check")
			return
			
		self.bk1=bk
		self.iterateIDList = iter(IDlist)		#Invokes items.__iter__()
		self.ID=next(self.iterateIDList)		#Load first ID in list
		self.html = self.bk1.readfile(self.ID)		#Read the section into html
		if not isinstance(self.html, text_type):		#If the section is not str
			self.html = text_type(self.html, 'utf-8')		#then sets its type to 'utf-8'
		self.html_orig = self.html						#Copy the result to html_orig
		
		self.dlgCheckWords()					#Display dialog box
		GenUtils.centerWindow(self.top)			#and centre it
		self.GetNextWord()						#Get first word to check and its replacement; calls getLines() to find all lines with this word
		if len(self.TextLines)!=0:				#If any lines contain this word
			self.NextLine()						#Get first line with this word
			self.top.wait_window(self.top)		#Wait for dialog to close...





