#!/usr/bin/env python 
# -*- coding: utf-8 -*- 
import sys

def run(BookContainer): 
    print("Entered Target Script run() routine")

    try:
        import PyQt5.QtWidgets
        import PyQt5.QtCore
        import PyQt5.QtGui
        print("import PyQt5 success")
    except ImportError:
        print("Missing PyQt5")
        return 1
    from PyQt5.QtCore import Qt
    from PyQt5.QtWidgets import QApplication,QWidget,\
                                QHBoxLayout,QSplitter
    from SearchSplitterWidget import SearchSplitterWidget
    from PrintWidget import PrintWidget
    prefs = BookContainer.getPrefs()
    if 'func' not in prefs:
        prefs['func']={}
    functionPrefs=prefs['func']
    oldStdout=sys.stdout
    app = QApplication(sys.argv)
    widget = QWidget()

    mainSplitter=QSplitter(Qt.Orientation.Horizontal)
    mainSplitter.addWidget(SearchSplitterWidget(BookContainer,functionPrefs))
    printWidget=PrintWidget()
    mainSplitter.addWidget(printWidget)
    sys.stdout = printWidget

    mainLayout=QHBoxLayout()
    mainLayout.addWidget(mainSplitter)
    widget.setLayout(mainLayout)
    widget.show()
    app.exec_()
    sys.stdout=oldStdout
    BookContainer.savePrefs(prefs)
    return 0

def main(): 
    print("I reached main when I should not have\n")
    return -1

if __name__ == "__main__":
    sys.exit(main())
