from PyQt5.QtWidgets import QSplitter
from PyQt5.QtCore import Qt
from SearchGridWidget import SearchGridWidget,FindMode
from FunctionEditorWidget import FunctionEditorWidget
import re
class SearchSplitterWidget(QSplitter):
    def __init__(self,BookContainer,functionPrefs ={}, parent= None) :
        super().__init__(Qt.Orientation.Vertical,parent)
        self.functionPrefs=functionPrefs
        self.BookContainer=BookContainer
        self.functionEditorWidget= FunctionEditorWidget()
        self.searchGridWidget= SearchGridWidget(functionPrefs)
        self.functionEditorWidget.textChanged.connect(self.autoSave)
        self.searchGridWidget.functionSelectedSignal.connect(self.selectFunction)
        self.searchGridWidget.replaceAllSignal.connect(self.replaceAll)
        self.addWidget(self.searchGridWidget)
        self.addWidget(self.functionEditorWidget)
        self.selectFunction(self.searchGridWidget.getFunctionName())
    def selectFunction(self,name):
        if name:
            self.functionEditorWidget.setPlainText(self.functionPrefs[name])
        else:
            self.functionEditorWidget.clear()
    def autoSave(self):
        name=self.searchGridWidget.getFunctionName()
        if name:
            self.functionPrefs[name]=self.functionEditorWidget.toPlainText()
    def replaceAll(self,pattern,name,mode):
        def iterConvert(iterator):
            return map(lambda x:(x[1],self.BookContainer.id_to_href(x[1])),filter(lambda x:x[0]=='manifest',iterator))
        func=self.functionPrefs[name]
        replaceDict={}
        exec(func,replaceDict)
        if 'replace' in replaceDict:
            replace=replaceDict['replace']
            if hasattr(replace, '__call__'):
                global count
                global filename
                global funcData
                count=1
                filename=''
                funcData={}
                def repl(match):
                    global count
                    global filename
                    global funcData
                    if match:
                        result=match.group(0)
                    else:
                        result=''
                    try:
                        result=replace(match,count,filename,self.BookContainer.getmetadataxml(),funcData)
                    except Exception as e:
                        print(e)
                    count+=1
                    return result
                if mode==FindMode.all_html.value:
                    iter=self.BookContainer.text_iter()
                elif mode==FindMode.selected_html.value:
                    iter=filter(lambda x:x[1].endswith('.html') or x[1].endswith('.xhtml') ,iterConvert(self.BookContainer.selected_iter()))
                elif mode==FindMode.all_css.value:
                    iter=self.BookContainer.css_iter()
                elif mode==FindMode.selected_css.value:
                    iter=filter(lambda x:x[1].endswith('.css'),iterConvert(self.BookContainer.selected_iter()))
                elif mode==FindMode.all_selected.value:
                    iter=iterConvert(self.BookContainer.selected_iter())
                elif mode==FindMode.all_file.value:
                    iter=map(lambda x:(x[0],x[1]),self.BookContainer.manifest_iter())
                for manifest_id, OPF_href in iter:
                    data=self.BookContainer.readfile(manifest_id)
                    if isinstance(data, str):
                        filename=self.BookContainer.href_to_basename(OPF_href)
                        data=re.sub(pattern,repl,data,flags=re.M)
                        self.BookContainer.writefile(manifest_id,data)
                filename=''
                repl(None)