from PyQt5.QtWidgets import QApplication,QWidget,QHBoxLayout,QVBoxLayout,QTextEdit,QPushButton
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtGui import QTextCursor
from BorderFrame import BorderFrame

class PrintWidget(BorderFrame):
    printSignal = pyqtSignal(str)
    def __init__(self, parent=None) -> None:
        super().__init__(parent)
        self.printReadArea=QTextEdit()
        self.printReadArea.setReadOnly(True)
        
        self.controlButtonWidget=QWidget()
        self.controlButtonLayout=QHBoxLayout()
        self.clearPushButton=QPushButton('Clear all')
        self.copyPushButton=QPushButton('Copy all')
        self.controlButtonLayout.addWidget(self.clearPushButton)
        self.controlButtonLayout.addWidget(self.copyPushButton)
        self.controlButtonLayout.addStretch(0)
        self.controlButtonWidget.setLayout(self.controlButtonLayout)


        self.printWidgetLayout=QVBoxLayout()
        self.printWidgetLayout.addWidget(self.controlButtonWidget)
        self.printWidgetLayout.addWidget(self.printReadArea)

        self.setLayout(self.printWidgetLayout)
        
        self.printSignal.connect(self.onUpdateText)
        self.clearPushButton.clicked.connect(self.clearAll)
        self.copyPushButton.clicked.connect(self.copyAll)
        
    def onUpdateText(self, text):
        self.printReadArea.moveCursor(QTextCursor.MoveOperation.End)
        self.printReadArea.insertPlainText(text)
        QApplication.processEvents()

    def write(self, text):
        self.printSignal.emit(str(text))

    def clearAll(self):
        self.printReadArea.clear()
    def copyAll(self):
        self.printReadArea.selectAll()
        self.printReadArea.copy()
        cursor=self.printReadArea.textCursor()
        cursor.clearSelection()
        self.printReadArea.setTextCursor(cursor)

