#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, os.path, sys, shutil, inspect
from tempfile import mkdtemp                  
from cutils import *
from dialog import UserReport
import options
from updater import updateCheck
import tkinter as tk


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3596476&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    
def runUserDialog(bk):
    root = tk.Tk()
    root.title('IDErrorCheck Log')
    root.option_add('*font', 'Arial -12')
    root.resizable(width=True, height=True)
    if not sys.platform.startswith('darwin'):
        img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        root.tk.call('wm','iconphoto', root._w, img)
    UserReport(root).pack(fill="both", expand=True)
    root.mainloop()
    return(0)        
    
# borrowed from DiapDealer with thanks...    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass

    return False    
    
def run(bk):  
    print('Python version: ', sys.version, '\n')
    print('Running IDErrorCheck...Please wait\n') 
    
    if is_connected:
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new plugin version is available on MR - v" + latest_version
    
    # only epub 2 is allowed for input
    epubversion = "2.0"
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()
    if epubversion.startswith("3"):
        msg = "This plugin requires a valid epub 2.0 ebook as input. " + \
              "Please try again."        
        print("Error: IDErrorCheck requires a valid epub 2.0 ebook as input")      
        show_msgbox('Incompatible Epub Version', msg, msgtype="error")
        return(-1)  
    
    # create a work directory
    WDIR = mkdtemp()
    options.WDIR = WDIR    
    
    # process all tasks
    processAllTasks(bk, WDIR)
   
    if options.SYS_EXIT == True:
        cleanExit(WDIR)
        return(-1) 
    
    if options.RESULTS == []:
        msg = 'No ID problems found!!'
        show_msgbox('IDErrorCheck', msg, msgtype='info') 
        
        if options.NEW_PLUGIN_VERSION == True:
            msg2 = options.MSG_NEW_VERSION_AVAILABLE
            show_msgbox('IDErrorCheck', msg2, msgtype='info')     
            
        cleanExit(WDIR)
        return(0)         
    
    runUserDialog(bk)     
    
    # inform user if new plugin version is available
    if options.NEW_PLUGIN_VERSION == True:
        msg = options.MSG_NEW_VERSION_AVAILABLE
        show_msgbox('IDErrorCheck', msg, msgtype='info') 
    
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    cleanExit(WDIR)
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())        