#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, platform
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

OS = platform.system()

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserReport(tk.Frame):
    def __init__(self, parent):
        tk.Frame.__init__(self, parent)
        self.parent = parent
        centeredWindow(self.parent, 350, 270)
        parent.minsize(150, 150)
        parent.maxsize(600, 700)
        self.parent.protocol("WM_DELETE_WINDOW", self.onExit)
        self.setup_UI()        
  
    def setup_UI(self):
        self.canvas=Canvas(self,bg='#FFFFFF',scrollregion=(0,0,500,5000))
        self.canvas_id = self.canvas.create_text(10, 10, anchor="nw")
        
        hbar=ttk.Scrollbar(self.canvas,orient=HORIZONTAL)
        hbar.pack(side=BOTTOM,fill=X)
        hbar.config(command=self.canvas.xview)
        
        vbar=ttk.Scrollbar(self.canvas,orient=VERTICAL)
        vbar.pack(side=RIGHT,fill=Y)
        vbar.config(command=self.canvas.yview)
        
        self.canvas.config(width=350,height=270)
        self.canvas.config(xscrollcommand=hbar.set, yscrollcommand=vbar.set)
        self.canvas.pack(expand=True,fill=BOTH)
        self.canvas.bind_all("<MouseWheel>", self.onMousewheelRoll)
        
        infolbl = Label(self).pack(fill=X)
 
        BlankButton = Button(self, 
                        text    = "",
                        bd = 0,
                        relief = FLAT,
                        width = 1,                        
                        ).pack(side=RIGHT)
        
        styler = ttk.Style()
        styler.configure('New.TButton', background='#E0E0E0', width=9, relief=FLAT) 
        ContinueButton = ttk.Button(self, 
                        text    = "Continue", 
                        style   = 'New.TButton', 
                        command = self.onContinue
                        ).pack(side=RIGHT, padx=5, pady=20) 

        styler.configure('New.TButton', background='#E0E0E0', width=9, relief=FLAT) 
        SaveLogButton = ttk.Button(self, 
                        text    = "Save Log", 
                        style   = 'New.TButton', 
                        command = self.onSaveAs
                        ).pack(side=RIGHT, padx=5, pady=20)                        
      
        #**** Create the statusbar *****#
        self.status = Label(self, text="",
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.pack(padx=3) 
        self.showReport()
        self.grab_set()       
      
    def onMousewheelRoll(self, event):
        if OS == 'Windows':
            self.canvas.yview('scroll', -1*(int(event.delta/120)), UNITS)
        
        elif OS == 'Darwin':
            self.canvas.yview('scroll', -1*(event.delta), UNITS)
            
        elif OS == 'Linux':
            self.canvas.bind('<4>', lambda event : self.canvas.xview('scroll', -1, UNITS))
            self.canvas.bind('<5>', lambda event : self.canvas.xview('scroll', 1, UNITS))    
                    
     
    def onSaveAs(self): 
        f = fdbox.asksaveasfile(title='Save Log', 
                initialdir=os.path.expanduser('~'), 
                initialfile='ID_ERRORS.txt', 
                mode='w', 
                filetypes = [('Text Files', '.txt')],
                defaultextension=".txt"
                )
        
        # exit if cancel is pressed
        if f is None:
            return(0)
        
        # save error data to the log file
        f.write("\n***** IDErrorCheck Log *****\n")             
        f.write(self.result_format)
        f.close()
        self.parent.destroy()  
                
    def onContinue(self):
        self.parent.destroy()        
        
    def onExit(self):
        self.parent.destroy()     
      
    def showReport(self):
        self.result_format = ''
        for index, result in enumerate(options.RESULTS):        
            results = list(result)
            self.result_format = self.result_format + '\n' + results[0] + ' ** ' + str(results[1]) + ' ** ' +  results[2]    
        self.canvas.itemconfig(self.canvas_id, text=self.result_format)    
            
            
if __name__== '__main__':
    root = tk.Tk()
    root.title('Error Report')
    root.resizable(width=True, height=True)
    #if not sys.platform.startswith('darwin'):
    #    img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
    #    root.tk.call('wm','iconphoto', root._w, img)
    UserReport(root).pack(side="top", fill="both", expand=True)
    root.mainloop()
        