#!/usr/bin/env python
# -*- coding: utf-8 -*-



__license__   = 'GPL v3'
__copyright__ = '2019, Jürgen Habelt <juergen@habelt-jena.de>'
__docformat__ = 'restructuredtext en'

from calibre.utils.podofo import get_outline

try:
    from calibre_plugins.toc_view_generator.ruby_port.extractor import Extractor

except ImportError:
    from ruby_port.extractor import Extractor


class PdfExtractor(Extractor):
    '''
    Class responsible for extracting and structuring book mark information
    '''
    
    def __init__(self, invoker):
        '''
        Initialization
        @param invoker: the injected Invoker is responsible for invoking other processes 
        '''
        self.invoker = invoker
        
        
    def extract(self, frm):
        '''
        Extracts the book mark info from PDF file and writes it into a text file
        @param frm: the PDF file from which to extract the book marks
        '''
        toc = get_outline(frm)

        return { 'title': 'Root', 'children': toc }
        
        