#!/usr/bin/env python
# -*- coding: utf-8 -*-



__license__   = 'GPL v3'
__copyright__ = '2019, Jürgen Habelt <juergen@habelt-jena.de>'
__docformat__ = 'restructuredtext en'

from calibre.ebooks.oeb.polish.container import EpubContainer
from calibre.ebooks.oeb.polish.toc import get_toc

try:
    from calibre_plugins.toc_view_generator.logging_factory import LoggingFactory
    from calibre_plugins.toc_view_generator.ruby_port.extractor import Extractor

except ImportError:
    from logging_factory import LoggingFactory
    from ruby_port.extractor import Extractor


class EpubExtractor(Extractor):
    '''
    Class responsible for extracting and structuring book mark information
    '''
    
    def __init__(self, invoker):
        '''
        Initialization
        @param invoker: the injected Invoker is responsible for invoking other processes 
        '''
        self.invoker = invoker
    
    
    def extract(self, frm):
        '''
        Extracts the book mark info from EPUB file and writes it into a XML file
        @param frm: the EPUB file from which to extract the book marks
        '''
        log = LoggingFactory().getLogger(self)
        container = EpubContainer(frm, log)
        toc = get_toc(container).to_dict()
        
        return toc
