#!/usr/bin/env python
# -*- coding: utf-8 -*-



__license__   = 'GPL v3'
__copyright__ = '2019, Jürgen Habelt <juergen@habelt-jena.de>'
__docformat__ = 'restructuredtext en'

try:
    from calibre_plugins.toc_view_generator.logging_factory import LoggingFactory

except ImportError:
    from logging_factory import LoggingFactory


class Bookmark(object):
    '''
    Contains the port from Ruby of the Book mark class
    '''

    def __init__(self, title, level = 0, parent = None):
        '''
        Constructor
        '''
        self.title = title
        self.level = level
        self.parent = parent
        self.children = []
        self.number = -1
        
    
    def __str__(self):
        '''
        Converts the book mark into string
        '''
        s = "  " * self.level + "Level: %d, Title: %s\n" % (self.level, self.title)
        if len(self.children) > 0:
            s += '  ' * self.level + "Children: \n"
            for child in self.children:
                s += str(child)
        return s
    
    
    def to_log(self):
        '''
        Logs book mark 
        '''
        s = "  " * self.level + "Level: %d, Title: %s" % (self.level, self.title)
        LoggingFactory().getLogger(self).debug(s)        
        if len(self.children) > 0:
            s = '  ' * self.level + "Children: "
            LoggingFactory().getLogger(self).debug(s)        
            for child in self.children:
                child.to_log()
        