#!/usr/bin/env python
# -*- coding: utf-8 -*-




__license__   = 'GPL v3'
__copyright__ = '2019, Jürgen Habelt <juergen@habelt-jena.de>'
__docformat__ = 'restructuredtext en'


try:
    from calibre_plugins.toc_view_generator.logging_instance import LoggingInstance
    
except ImportError:
    from logging_instance import LoggingInstance


class LoggingFactory(object):
    '''
    Supports logging, maintains all logger instances
    '''

    _singleton = None

    def __new__(cls, *args, **kwargs):
        '''
        Overrides the __new__ method. Every constructor call returns then the
        same instance.
        TODO: test if this works, when we derive different subclasses from it
        '''
        if not LoggingFactory._singleton:
            LoggingFactory._singleton = object.__new__(LoggingInstance, *args, **kwargs)
            LoggingFactory._singleton.__init__()
        
        return LoggingFactory._singleton
