#!/usr/bin/env python
# -*- coding: utf-8 -*-



__license__   = 'GPL v3'
__copyright__ = '2019, Jürgen Habelt <juergen@habelt-jena.de>'
__docformat__ = 'restructuredtext en'

globals()['load_translations']()


from PyQt5.Qt import QDialog, QHeaderView

try:
    from calibre_plugins.toc_view_generator.model import RequirementsModel, RequirementsDelegate
    from calibre_plugins.toc_view_generator.gui.RequirementsView_ui import Ui_requirementsView

except ImportError:
    from model import RequirementsModel, RequirementsDelegate
    from gui.RequirementsView_ui import Ui_requirementsView

       
class RequirementsView(QDialog, Ui_requirementsView): 
    '''
    Dialog class using the UI generated python class Ui_RequirementsView
    '''

    def __init__(self):
        '''
        Initializes the Dialog with the UI
        '''
        super(RequirementsView, self).__init__()
        self.setupUi(self)
        self.setWindowTitle(_('Requirements'))
        
        self.model = RequirementsModel(self.tableView)
        self.tableView.setModel(self.model)
        self.delegate = RequirementsDelegate(self)
        self.tableView.setItemDelegate(self.delegate)

        self.tableView.horizontalHeader().setSectionResizeMode(1, QHeaderView.ResizeToContents)
        self.tableView.horizontalHeader().setSectionResizeMode(0, QHeaderView.Stretch)
