#!/bin/bash

if [ $# -ne 1 ]; then
    echo "use: ./cripple_network.sh <path_to_firmware_root>"
    exit 1
fi
KOBOROOT="${1}"
if [ -z "${KOBOROOT}" ]; then
    echo "<path_to_firmware_root> must not be empty"
    exit 1
fi

if [[ "${KOBOROOT}" != */ ]]; then
    KOBOROOT="${KOBOROOT}/"
fi

if [ ! -s "${KOBOROOT}"etc/init.d/rcS ]; then
    echo "<path_to_firmware_root> does not appear to be path to kobo firmware root"
    echo "etc/init.d/rcS not found in ${KOBOROOT}"
    exit 1
fi

rm -rf "${KOBOROOT}"drivers/mx6ull-ntx/wifi/
rm -rf "${KOBOROOT}"drivers/mx6sll-ntx/wifi/
rm -rf "${KOBOROOT}"bin/wpa*
rm -rf "${KOBOROOT}"bin/wlarm_le
rm -rf "${KOBOROOT}"bin/wlfmac*
rm -rf "${KOBOROOT}"sbin/ip*
rm -rf "${KOBOROOT}"sbin/ifconfig
rm -rf "${KOBOROOT}"sbin/ifdown
rm -rf "${KOBOROOT}"sbin/ifup
rm -rf "${KOBOROOT}"sbin/route
rm -rf "${KOBOROOT}"sbin/dhcp*
rm -rf "${KOBOROOT}"sbin/udhcp*
rm -rf "${KOBOROOT}"libexec/dhcpcd-*
rm -rf "${KOBOROOT}"etc/dhcp*
rm -rf "${KOBOROOT}"etc/udhcp*
rm -rf "${KOBOROOT}"etc/dbus-1/system.d/dhcpcd-dbus.conf

# remove code setting env variables WIFI_MODULE nad INTERFACE from etc/init.d/rcS
sed -i -z 's/\n\/bin\/hostname kobo\n.*\nexport WIFI_MODULE\n/\
\n\/bin\/hostname kobo\
\
export WIFI_MODULE=""\
export INTERFACE=""\
/' "${KOBOROOT}"etc/init.d/rcS
