#!/bin/bash

if [ $# -ne 2 ] && [ $# -ne 3 ]; then
    echo "use: ./replace_with_plato.sh <path_to_firmware_root> <path_to_plato_root> [\"remove_clock_from_ui\"]"
    exit 1
fi

KOBOROOT="${1}"
if [ -z "${KOBOROOT}" ]; then
    echo "<path_to_firmware_root> must not be empty"
    exit 1
fi

if [[ "${KOBOROOT}" != */ ]]; then
    KOBOROOT="${KOBOROOT}/"
fi

if [ ! -s "${KOBOROOT}"etc/init.d/rcS ]; then
    echo "<path_to_firmware_root> does not appear to be path to kobo firmware root"
    echo "etc/init.d/rcS not found in ${KOBOROOT}"
    exit 1
fi

RCS="${KOBOROOT}"etc/init.d/rcS

PLATOROOT="${2}"
if [ -z "${PLATOROOT}" ]; then
    echo "<path_to_plato_root> must not be empty"
    exit 1
fi

if [[ "${PLATOROOT}" != */ ]]; then
    PLATOROOT="${PLATOROOT}/"
fi

if [ ! -s "${PLATOROOT}"plato.sh ]; then
    echo "<path_to_plato_root> does not appear to be path toplato root"
    echo "plato.sh not found in ${PLATOROOT}"
    exit 1
fi

REMOVE_CLOCK_FROM_UI=0
if [ $# -eq 3 ]; then
    if [ "${3}" != "remove_clock_from_ui"  ]; then
        echo "If run with three arguments, the third argument must be remove_clock_from_ui"
        echo "example: "
        echo "./replace_with_plato.sh path_to_koboroot path_to_platoroot remove_clock_from_ui"
        exit 1
    fi
    REMOVE_CLOCK_FROM_UI=1
fi

# 1) copy PLATOROOT to /opt/plato
# 2) remove on-animator
# 3) remove 'should-factory-reset' test from boot script
# 4) remove 'nickel' from boot script
# 5) add plato to boot script
# 6) optionally diable clock in plato UI

# 1) copy PLATOROOT to /opt/plato
mkdir -p "${KOBOROOT}"opt/
cp -r "${PLATOROOT}" "${KOBOROOT}"opt/plato

# 2) remove on-animator
echo > "${KOBOROOT}"etc/init.d/on-animator.sh

# 3) remove 'should-factory-reset' test from boot script
sed -i 's/^\/usr\/local\/Kobo\/pickel should-factory-reset$/echo ""/' "${RCS}"

# 4) remove 'nickel' from boot script
sed -z -i 's/\n[^\n]*\/usr\/local\/Kobo\/nickel[^\n]*\n/\n/' "${RCS}"

# 5) add plato to boot script
if ! grep '/opt/plato/plato.sh' "${RCS}" > /dev/null; then
    echo "/opt/plato/plato.sh &" >> "${RCS}"
fi

# 6) optionally diable clock in plato UI
if [ ${REMOVE_CLOCK_FROM_UI} -eq 1 ] && [ -s "${KOBOROOT}"opt/plato/Settings-sample.toml ]; then
    cp "${KOBOROOT}"opt/plato/Settings-sample.toml "${KOBOROOT}"opt/plato/Settings.toml
    sed -i 's/time-format =.*/time-format = ""/' "${KOBOROOT}"opt/plato/Settings.toml
    sed -i 's/date-format =.*/date-format = ""/' "${KOBOROOT}"opt/plato/Settings.toml
fi
