
import pdf
import pdfinfo
import imgs
import imgsinfo

def get_input_info(config):
    iformat = config.input_format
    if iformat == 'pdf':
        info_parser = pdfinfo.PDFInfoParser(config)
    elif iformat == 'imgs':
        info_parser = imgsinfo.ImgsInfoParser(config)
    else:
        print 'Invalid input format: %s' % (iformat)
        sys.exit(-1)
    return info_parser.parse()

def create_input_to_ppm(config):
    if config.input_format == 'pdf':
        return create_pdf_to_ppm(config)
    elif config.input_format == 'imgs':
        return imgs.IMGSToPPM(config)
