#!/usr/bin/python

import os.path
from util import *

class Bookmark(object):
    def __init__(self, title = None, page = None):
        object.__init__(self)
        self.title = title
        self.page = page

class ImgsInfo(object):
    def __init__(self, doc_title, author, pages):
        object.__init__(self)
        self.doc_title = doc_title
        self.author = author
        self.pages = pages

def get_bookmarks(imgs_dir):
    f = file(os.path.join(imgs_dir, "toc"), "r")
    bms = []
    for l in f:
        p = l.find(" ")
        if p == -1:
            continue
        title = l[p+1:].strip()
        page = int(l[:p])
        bms.append(Bookmark(title, page))
    f.close()
    return bms

def get_imgs_list(imgs_dir):
    f = file(os.path.join(imgs_dir, "list"), "r")
    imgs_list = []
    for l in f:
        imgs_list.append(l.rstrip())
    f.close()
    return imgs_list

def get_info(imgs_dir):
    f = file(os.path.join(imgs_dir, "info"), "r")
    info_kv = kv(f)
    doc_title = info_kv.get("title", imgs_dir)
    author = info_kv.get("author", "")
    imgs_list = get_imgs_list(imgs_dir)
    info = ImgsInfo(doc_title, author, len(imgs_list))
    info.bookmarks = get_bookmarks(imgs_dir)
    return (info, info.bookmarks)

class ImgsInfoParser(object):
    def __init__(self, config):
        object.__init__(self)
        self.imgs_dir = config.input_fn
    def parse(self):
        return get_info(self.imgs_dir)

def print_bookmarks(bms):
    for bm in bms:
        print bm.title.encode('utf-8'), bm.page

if __name__ == '__main__':
    import sys
    info = get_info(sys.argv[1])
    print 'title:', info.doc_title.encode('utf-8')
    print 'author:', info.author.encode('utf-8')
    print 'pages:', info.pages
    print_bookmarks(info.bookmarks)
