from subprocess import call
import os.path

from image import PageImageRef

def get_imgs_list(imgs_dir):
    f = file(os.path.join(imgs_dir, "list"), "r")
    imgs_list = []
    for l in f:
        imgs_list.append(l.rstrip())
    f.close()
    return imgs_list

class IMGSToPPM(object):
    def __init__(self, config):
        object.__init__(self)
        self.imgs_dir = config.input_fn
        self.output_prefix = config.output_prefix
        self.imgs_list = get_imgs_list(self.imgs_dir)
    def get_image(self, page_num):
        iimg_fn = os.path.join(self.imgs_dir, self.imgs_list[page_num-1])
        oimg_fn = "%s-%d.pgm" % (self.output_prefix, page_num)
        ret = call(['convert', iimg_fn, oimg_fn])
        assert(ret == 0)
        return PageImageRef(page_num, file_name = oimg_fn)
