#!/usr/bin/python
#
# Copyright 2008 Huang Ying <huang.ying.caritas@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#

import sys
import os
import random
import shutil

import pi.input
import pi.image
import pi.divide
import pi.assembler
import pi.generator
from pi.util import *

class Config(object):
    def __init__(self):
        object.__init__(self)
    def load(self, conf_kv):
        self.kv = conf_kv
        self.input_fn = conf_kv.get('input')
        self.input_format = conf_kv.get('input_format', 'pdf')
        self.input_type = conf_kv.get('input_type', 'graph')
        self.divide = conf_kv.get('divide', 2, int)
        self.margin = conf_kv.get('margin', 1, int)
        ow = conf_kv.get('out_width', 600, int)
        oh = conf_kv.get('out_height', 800, int)
        self.out_size = (ow, oh)
        self.empty_coeff = conf_kv.get('empty_coeff', 0.95, float)
        self.max_il_coeff = conf_kv.get('max_il_coeff', 1.0 / 12, float)
        self.flex_coeff = conf_kv.get('flex_coeff', None, float)
        self.fix_figure_by_vspace = conf_kv.get('fix_figure_by_vspace',
                                                True, str2bool)
        self.fix_figure_by_halign = conf_kv.get('fix_figure_by_halign',
                                                True, str2bool)
        self.merge_center = conf_kv.get('merge_center', True, str2bool)
        self.merge_sparse = conf_kv.get('merge_sparse', True, str2bool)
        self.vector_parse = conf_kv.get('vector_parse', False, str2bool)
        self.run_pages = conf_kv.get('run_pages', False, str2bool)
        self.unpaper = conf_kv.get('unpaper', 'null')
        self.dilate = conf_kv.get('dilate', True, str2bool)
        self.trim_left = conf_kv.get('trim_left', 0., float) / 100.
        self.trim_top = conf_kv.get('trim_top', 0., float) / 100.
        self.trim_right = conf_kv.get('trim_right', 0., float) / 100.
        self.trim_bottom = conf_kv.get('trim_bottom', 0., float) / 100.
        self.overlap = conf_kv.get('overlap', 10., float) / 100.
        self.parsing_dpi = conf_kv.get('parsing_dpi', 180, int)
        self.rendering_dpi = conf_kv.get('rendering_dpi', 360, int)
        self.opedge_ex = conf_kv.get('opedge_ex', 2, int)

        self.colors = conf_kv.get('colors', 4, int)
        self.rotate = conf_kv.get('rotate', False, str2bool)
        self.output_prefix = conf_kv.get('output_prefix')
        self.out_format = conf_kv.get('out_format', 'image')
        self.out_file_name = conf_kv.get('out_file_name')

        meta, bms = pi.input.get_input_info(self)
        self.out_title = conf_kv.get('out_title', meta.doc_title)
        self.out_author = conf_kv.get('out_author', meta.author)
        self.bookmarks = conf_kv.get('bookmarks', bms)
        self.first_page = conf_kv.get('first_page', 1, int)
        self.last_page = conf_kv.get('last_page', meta.pages, int)
        if sys.platform == 'win32':
            default_pfw = 6      # this is a workaround for the Windows version
        else:
            default_pfw = len('%d' % (meta.pages,))
        self.pfw = conf_kv.get('pfw', default_pfw)
    def check(self):
        if self.input_fn is None:
            print 'Please specify pdf file name!'
            sys.exit(-1)
        if self.input_fn.endswith('.pdf'):
            self.input_fn_base = self.input_fn[:-4]
        else:
            self.input_fn_base = self.input_fn

        self.tmp_dir = '/tmp/pi-%d' % (os.getpid())

        if self.out_format == 'image':
            if self.output_prefix is None:
                print 'Please specify output_prefix for image output format!'
                sys.exit(-1)
        elif self.out_format == 'lrf':
            if self.output_prefix is None:
                self.output_prefix = self.tmp_dir + '/out'
            if self.out_file_name is None:
                self.out_file_name = self.input_fn_base + '.lrf'

        if self.out_title == '':
            self.out_title = self.input_fn_base

def reformat(conf_fn):
    def load_config(conf_fn):
        config_kv = kv(file(conf_fn))
        conf = Config()
        conf.load(config_kv)
        conf.check()
        os.mkdir(conf.tmp_dir)
        return conf

    def clean():
        shutil.rmtree(config.tmp_dir);

    def page_hl_parser_train():
        nsample = min(10, (config.last_page-config.first_page+1)/2)
        nsample = max(nsample, 1)
        for i in range(nsample):
            pn= random.randint(config.first_page, config.last_page)
            pimg_ref = pdftoppm.get_image(pn)
            pimg_ref = precrop.convert(pimg_ref)
            pimg_ref = unpaper.convert(pimg_ref)
            page = page_parser.parse(pimg_ref)
            page_hl_parser.train(page)
        page_hl_parser.end_train()

    random.seed()
    config = load_config(conf_fn)

    inputtoppm = pi.input.create_input_to_ppm(config)
    precrop = pi.image.PreCrop(config)
    unpaper = pi.image.create_unpaper(config)
    dilate = pi.image.create_dilate(config)
    page_parser = pi.divide.PageParser(config)
    page_hl_parser = pi.divide.create_page_hl_parser(config)
    page_divider = pi.divide.create_page_divider(config)
    assembler = pi.assembler.Assembler(config)
    post_proc = pi.image.PostProc(config)
    collector = pi.image.Collector(config)
    generator = pi.generator.create_generator(config)

    if config.divide > 1:
        page_hl_parser_train()

    for pn in range(config.first_page, config.last_page+1):
        print 'page: %d' % (pn,)

        last = (pn == config.last_page)
        pimg_ref = inputtoppm.get_image(pn)
        pimg_ref = precrop.convert(pimg_ref)
        pimg_ref = unpaper.convert(pimg_ref)
        dilate_pimg_ref = dilate.convert(pimg_ref)
            
        page = page_parser.parse(pimg_ref)
        pimg_ref = None
        page = page_hl_parser.hl_parse(page)
        segs = page_divider.divide(page, dilate_pimg_ref)
        page = None
        dilate_pimg_ref = None
        opimg_refs = assembler.assemble(segs)
        segs = None
        if last:
            opimg_refs_rem = assembler.end()
            opimg_refs.extend(opimg_refs_rem)
            opimg_refs_rem = None

        for opimg_ref in opimg_refs:
            opimg_ref = post_proc.convert(opimg_ref)
            collector.collect(opimg_ref)
        if last:
            collector.end()
        opimg_refs = None

    generator.generate(collector.out_files, collector.page_map)

    clean()
