#!/bin/sh

set -e

usage()
{
	echo "Usage: `basename $0` <img_dir> <pdf_fn>"
}

if [ $# -ne 2 ]; then
	usage
fi

img_dir=$1
pdf_fn=$2

cwd=`pwd`
cd $img_dir

for f in *.png; do
	nf=`echo $f | sed 's/png/tif/g'`
	nf=`basename $nf`
	convert -colors 4 -depth 8 $f $nf
	convert $f $nf
done

tiffcp *.tif pdf-$pdf_fn.tiff
tiff2pdf -nz -o $cwd/$pdf_fn pdf-$pdf_fn.tiff

rm *.tif *.tiff
