# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.115"    # Download Web Series, Indexes, LCCN, ISBN, PermaLinks, Tags, Publisher, PubDate [Selected Single Real Author]

from calibre.gui2.threaded_jobs import ThreadedJob

from calibre_plugins.quarantine_and_scrub.booklevel import main_scrub_book_level
from calibre_plugins.quarantine_and_scrub.authorlevel import main_scrub_author_level
from calibre_plugins.quarantine_and_scrub.serieslevel import main_scrub_series_level
from calibre_plugins.quarantine_and_scrub.copywork import  util_copy_original_metadata
from calibre_plugins.quarantine_and_scrub.copypristine import  util_copy_pristine_metadata
from calibre_plugins.quarantine_and_scrub.purgework import util_purge_work_data
from calibre_plugins.quarantine_and_scrub.sqlobjects import util_create_sqlite_objects
from calibre_plugins.quarantine_and_scrub.miscellany import main_scrub_miscellany
from calibre_plugins.quarantine_and_scrub.derivegenres import main_derive_genres

# ------------------------------------------------------------------------------
#    Functions to perform QuarantineAndScrub using ThreadedJob
# ------------------------------------------------------------------------------
def start_threaded_create_sqlite_objects(self, gui, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Create SQL Objects',util_create_sqlite_objects,(self, guidb), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will create new SQLite objects if required. '), 5000)

def start_threaded_purge_work_data(self, gui, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Purge Work Data',util_purge_work_data,(self, guidb), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will purge all work data'), 5000)

def start_threaded_book_level(self, gui, book_ids, scrubbed_books_final, my_plugin_path, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Book-Level Scrubbing',main_scrub_book_level,(self, guidb, book_ids, scrubbed_books_final, my_plugin_path), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will scrub your selected books at the book level'), 5000)

def start_threaded_author_level(self, gui, book_ids, scrubbed_books_final, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Author-Level Scrubbing',main_scrub_author_level,(self, guidb, book_ids, scrubbed_books_final), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will scrub all of your books for misplaced global/pristine authors'), 5000)

def start_threaded_series_level(self, gui, series_source_priority, run_type, callback):
    s_type = " "
    if run_type == "0":
        s_type = "What-If"
    if run_type == "1":
        s_type = "Actual"

    s_name = "Quarantine And Scrub: Series-Level Scrubbing - " + s_type

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin',s_name,main_scrub_series_level,(self, guidb,series_source_priority, run_type), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will scrub all of your books at the series level'), 5000)

def start_threaded_miscellany(self, gui, miscellany_option, run_type, selected_book_list, callback):
    #  Miscellaneous Scrubbing Options
    # Option 1: Propagate Tags from/to Books with Identical Series
    # Option 3: Book Level Tag Scrubbing [Selected Books]
    # Option 4: Verify Series Index Using Web Lookup  [Selected Books]
    # Option 5: Rename Work Series Name to Web Series Name[Previously Verified Fiction Series Only]
    # Option 9: Minimize Work Tags Using Tag Priorities [Selected Books]
    # Option 10: Copy Tag & Title Rules From/To Previously Configured Q&S Libraries
    # Option 14: Download Work Series/Titles/Indexes from Web Source for All Series for a Single Author [Single Author Only]
    # Option 15: Copy Work Tags to Custom Columns(s) Per Table "Tags CC Mapping Control" [Selected Books]
    # Option 16: Update Pseudonym Custom Column [Selected Books]

    s_type = " "
    if miscellany_option == "1":
        s_type = "Propagate Tags from/to Books with Identical Series"
    if miscellany_option == "3":
        s_type = "Book Level Tag Scrubbing"
    if miscellany_option == "4":
        s_type = "Verify Series Index Using Web Lookup"
    if miscellany_option == "5":
        s_type = "Rename Work Series Name to Web Series Name"
    if miscellany_option == "9":
        s_type = "Minimize Work Tags Using Tag Priorities"
    if miscellany_option == "10":
        s_type = "Copy Tag & Title Rules From/To Previously Configured Q&S Libraries"
    if miscellany_option == "14":
        s_type = "Download Web Series, Indexes, LCCN, ISBN, PermaLinks, Tags, Publisher, PubDate [Selected Single Real Author]"
    if miscellany_option == "15":
        s_type = 'Copy Work Tags to Custom Columns(s) Per Table "Tags CC Mapping Control" '
    if miscellany_option == "16":
        s_type = 'Update Pseudonym Custom Column'

    s_name = 'Quarantine And Scrub: Miscellany - ' + s_type

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin',s_name,main_scrub_miscellany,(self, guidb,miscellany_option, run_type, selected_book_list), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will perform your specified miscellaneous scrubbing option'), 5000)

def start_threaded_util_copy_original_metadata(self, gui, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Copy Real to Work',util_copy_original_metadata,(self, guidb), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will copy real data to work data'), 5000)

def start_threaded_util_copy_pristine_metadata(self, gui, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Copy Pristine Metadata',util_copy_pristine_metadata,(self, guidb), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This job will copy pristine data from your pristine library to the q+s database'), 5000)

def start_threaded_derive_genres(self, gui, book_ids, results_status, callback):

    guidb = self.gui.library_view.model().db
    job = ThreadedJob('quarantineandscrubplugin','Quarantine And Scrub: Derive Genres',main_derive_genres,(self, guidb, book_ids, results_status), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('The QS Derive Genres Job will update your selected books'), 5000)

#END of jobs.py
