# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020  DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.87"   # Miscellaneous technical changes to improve performance.

from calibre.customize import InterfaceActionBase

class ActionBaseMultiColumnSearch(InterfaceActionBase):

    name                    = 'MultiColumnSearch'
    description           = 'Advanced Search Tools: Inter-Book; Intra-Book; Cross-Library; Full-Text; Word-Book Index Search; Native SQL Queries; Cross-Library Duplicate Books per Custom Columns; and more.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 87)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin           = 'calibre_plugins.multi_column_search.ui:ActionMultiColumnSearch'

    gui_name = "MultiColumnSearch"

    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py