#~ # -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.170"   #Technical changes after Python 3.8 testing with Calibre 4.99.3

from PyQt5.Qt import (Qt, QDialog, QLabel,  QFont, QWidget, QApplication,
                                       QIcon, QGridLayout, QGroupBox, QMargins, QScrollArea,
                                       QTableWidget, QTableWidgetItem, QDialogButtonBox,
                                       QSize, QPushButton, QVBoxLayout, QHBoxLayout)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs

from polyglot.builtins import as_unicode

from calibre_plugins.job_spy.config import prefs

#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(90, 90)
    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent, Qt.WindowSystemMenuHint|Qt.WindowMinimizeButtonHint )
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)
        self.finished.connect(self.dialog_closing)
    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)
    def dialog_closing(self, result):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class RowSpyDialog(SizePersistedDialog):

    def __init__(self,maingui,parent):
        unique_pref_name = 'Job_Spy:rowspy_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.maingui = maingui
        self.guidb = self.maingui.library_view.model().db
        self.original_guidb = self.guidb

        mytitle = 'JS+ GUI Tool:  RowSpy'
        self.setWindowTitle(_(mytitle))

        layout = QVBoxLayout(self)
        self.setLayout(layout)

        self.n_log_rows = 1

        #--------------------------------------------------
        column_label_list = []
        column_label_list.append("ID")
        column_label_list.append("Authors")
        column_label_list.append("Title")
        column_label_list.append("Series")
        column_label_list.append("Index")

        self.n_total_cols = 5

        self.logtable = QTableWidget(self.n_log_rows,self.n_total_cols)

        self.logtable.setToolTip("<p style='white-space:wrap'>Left or Right Clicking or Doubling-Clicking the mouse on a book will automatically refresh the displayed metadata,\
                                                                                                as will moving the cursor via the keyboard to a new book and then pressing the Enter/Return key.")

        self.logtable.setSortingEnabled(False)

        self.logtable.setHorizontalHeaderLabels(column_label_list)

        self.logtable.verticalHeader().setVisible(False)

        self.logtable.setColumnWidth(0,  50)
        self.logtable.setColumnWidth(1, 200)
        self.logtable.setColumnWidth(2, 200)
        self.logtable.setColumnWidth(3, 200)
        self.logtable.setColumnWidth(4,   50)


        self.logtable.clearContents()
        #--------------------------------------------------

        self.last_bookid = 0

        layout.addWidget(self.logtable)

        self.resize_all_columns()

        #-----------------------------------------------------

        self.bottom_buttonbox = QDialogButtonBox()
        #~ self.bottom_buttonbox.rejected.connect(self.reject)
        layout.addWidget(self.bottom_buttonbox)

        self.push_button_optimize_column_widths = QPushButton(" ", self)
        self.push_button_optimize_column_widths.setText("Optimize")
        self.push_button_optimize_column_widths.setToolTip("<p style='white-space:wrap'>The metadata columns will be resized based on their longest row contents for each column.")
        self.push_button_optimize_column_widths.clicked.connect(self.optimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_optimize_column_widths,0)

        self.push_button_deoptimize_column_widths = QPushButton(" ", self)
        self.push_button_deoptimize_column_widths.setText("Deoptimize")
        self.push_button_deoptimize_column_widths.setToolTip("<p style='white-space:wrap'>The metadata columns will be resized to a fixed width regardless of their contents.")
        self.push_button_deoptimize_column_widths.clicked.connect(self.deoptimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_deoptimize_column_widths,0)

        self.push_button_refresh_rowspy = QPushButton(" ", self)
        self.push_button_refresh_rowspy.setText("Refresh Current Book")
        self.push_button_refresh_rowspy.setToolTip("<p style='white-space:wrap'>The metadata displayed will be refreshed using the currently selected book.  This button is rarely needed.\
                                                                                                                                <br><br>Left or Right Clicking or Doubling-Clicking the mouse on a book will automatically refresh the displayed metadata,\
                                                                                                                                as will moving the cursor via the keyboard to a new book and then pressing the Enter/Return key.")
        self.push_button_refresh_rowspy.clicked.connect(self.refresh_rowspy)
        self.bottom_buttonbox.addButton(self.push_button_refresh_rowspy,0)

        self.push_button_save_and_exit = QPushButton(" ", self)
        self.push_button_save_and_exit.setText("Exit RowSpy")
        self.push_button_save_and_exit.setToolTip("<p style='white-space:wrap'>Save current RowSpy window settings and then exit.")
        self.push_button_save_and_exit.clicked.connect(self.save_and_exit)
        self.bottom_buttonbox.addButton(self.push_button_save_and_exit,0)

        self.bottom_buttonbox.setCenterButtons(True)
        #-----------------------------------------------------
        self.refresh_rowspy()
        #-----------------------------------------------------
        self.resize_dialog()

        self.optimize_column_widths()

        self.update()

        self.maingui.library_view.selectionModel().currentChanged.connect(self.refresh_rowspy)

        #~ self.maingui.library_view.activated.connect(self.refresh_rowspy)
        #~ self.maingui.library_view.clicked.connect(self.refresh_rowspy)
        #~ self.maingui.library_view.doubleClicked.connect(self.refresh_rowspy)
        #~ self.maingui.library_view.entered.connect(self.refresh_rowspy)  #mouse tracking is not enabled...
        #~ self.maingui.library_view.pressed.connect(self.refresh_rowspy)

    #-----------------------------------------------------
    def resize_all_columns(self):
        self.logtable.resizeColumnsToContents()
        self.save_custom_columns_listing_dialog_geometry()
    #-----------------------------------------------------
    #-----------------------------------------------------
    def optimize_column_widths(self):
        self.logtable.resizeColumnsToContents()
        self.save_custom_columns_listing_dialog_geometry()
    #-----------------------------------------------------
    def deoptimize_column_widths(self):
        self.logtable.setColumnWidth(0, 50)
        self.logtable.setColumnWidth(1, 100)
        self.logtable.setColumnWidth(2, 100)
        self.logtable.setColumnWidth(3, 100)
        self.logtable.setColumnWidth(4, 50)

    #-----------------------------------------------------
    #-----------------------------------------------------
    def save_custom_columns_listing_dialog_geometry(self):
        self.dialog_closing(None)
    #-----------------------------------------------------
    #-----------------------------------------------------
    def save_and_exit(self):
        self.dialog_closing(None)
        try:
            self.maingui.library_view.selectionModel().currentChanged.disconnect(self.refresh_rowspy)
            #~ self.maingui.library_view.activated.disconnect(self.refresh_rowspy)
            #~ self.maingui.library_view.clicked.disconnect(self.refresh_rowspy)
            #~ self.maingui.library_view.doubleClicked.disconnect(self.refresh_rowspy)
            #~ self.maingui.library_view.entered.disconnect(self.refresh_rowspy)  #mouse tracking is not enabled...
            #~ self.maingui.library_view.pressed.disconnect(self.refresh_rowspy)
        except:
            pass
        self.close()
    #-----------------------------------------------------
    #-----------------------------------------------------
    def refresh_rowspy(self):
        #~ Note:  mi = self.maingui.library_view.model().db.get_metadata.........   avoids complications when changing libraries causing guidb changes, proper disconnection of events, and user not properly closing this dialog before changing the library.
        try:
            cix = self.maingui.library_view.currentIndex()
            if cix.isValid():
                bookid = self.maingui.library_view.model().id(cix)
                if bookid == self.last_bookid:
                    return
                self.last_bookid = bookid
                mi = self.maingui.library_view.model().db.get_metadata(bookid, index_is_id=True, get_user_categories=False)
                authorsx = mi.authors
                if isinstance(authorsx,list):
                    authors = authorsx[0]
                elif isinstance(authorsx,tuple):
                    authors = list(authorsx)
                    authors = authors[0]
                title = mi.title
                bookid = as_unicode(bookid)
                series = mi.series
                series_index = mi.series_index
                if not series_index:
                    series_index = ""
                series_index = as_unicode(series_index)
                del mi
                del authorsx
                #---------------------------
                #---------------------------
                bookid_ = QTableWidgetItem(bookid)
                authorsort_ = QTableWidgetItem(authors)
                title_ = QTableWidgetItem(title)
                series_ = QTableWidgetItem(series)
                series_index_ = QTableWidgetItem(series_index)
                #---------------------------
                #---------------------------

                r = 0

                self.logtable.setItem(r,0,bookid_)
                self.logtable.setItem(r,1,authorsort_)
                self.logtable.setItem(r,2,title_)
                self.logtable.setItem(r,3,series_)
                self.logtable.setItem(r,4,series_index_)
            else:
                if DEBUG: print("cix is NOT valid...")
                return
            #--------------------------------------
            #--------------------------------------
        except Exception as e:
            if DEBUG: print("Exception in: class RowSpyDialog, def refresh_rowspy :", as_unicode(e))
            return

        self.optimize_column_widths()
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END OF rowspy_dialog.py