# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.170"   #Technical changes after Python 3.8 testing with Calibre 4.99.3

from PyQt5.Qt import (Qt, QDialog, QLabel,  QFont, QWidget, QApplication,
                                       QIcon, QGridLayout, QGroupBox, QMargins, QScrollArea,
                                       QTableWidget, QTableWidgetItem, QDialogButtonBox,
                                       QSize, QPushButton, QVBoxLayout, QHBoxLayout)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs
from calibre.gui2.ui import get_gui
from calibre.utils.config import JSONConfig

from polyglot.builtins import as_unicode, iteritems, range, unicode_type

from calibre_plugins.job_spy.config import prefs

#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(200, 200)
    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)
        self.finished.connect(self.dialog_closing)
    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)
    def dialog_closing(self, result):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class BookIdentifierMatrixDialog(SizePersistedDialog):

    def __init__(self, parent,column_assignment_dict,final_column_number,book_data_dict,book_identifiers_dict):
        unique_pref_name = 'Job_Spy:list_book_identifier_matrix_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        mytitle = 'JS+ GUI Tool:  Book-Identifier Matrix'
        self.setWindowTitle(_(mytitle))

        layout = QVBoxLayout(self)
        self.setLayout(layout)

        #--------------------------------------------------

        column_label_list = []

        row = 0,"BookID"
        column_label_list.append(row)
        row = 1,"Title"
        column_label_list.append(row)
        row = 2,"Author Sort"
        column_label_list.append(row)

        #~ for type,colnum in column_assignment_dict.iteritems():               # [type] = column number  #starting with col 3
        for type,colnum in iteritems(column_assignment_dict):               # [type] = column number  #starting with col 3
            row = colnum,type
            if not type:
                continue
            if not type > " ":
                continue
            column_label_list.append(row)
        #END FOR

        column_label_list.sort()
        sorted_column_label_list = []

        for row in column_label_list:
            colnum,type = row
            sorted_column_label_list.append(type)
        #END FOR

        self.n_total_cols = final_column_number + 1

        #--------------------------------------------------
        #~ book_data_dict = {}  # [bookid] = title,author_sort
        #~ book_type_dict = {}   # [type] = val
        #~ book_identifiers_dict = {}  # [bookid] = book_type_dict

        matrix_list = []

        #~ for id,data in book_data_dict.iteritems():
        for id,data in iteritems(book_data_dict):
            title,author_sort = data
            newrow = as_unicode(id) + "||" + title + "||" + author_sort + "||"
            if not id in book_identifiers_dict:
                if DEBUG: print("ERROR: id not in book_identifiers_dict...")
                continue
            book_type_dict = book_identifiers_dict[id]
            for row in column_label_list:
                colnum,type = row
                if colnum < 3:  # 0 id, 1 title, 2 author_sort
                    continue
                if type in book_type_dict:
                    newrow = newrow + book_type_dict[type] + "||"
                else:
                    newrow = newrow + " " + "||"
            #END FOR
            matrix_list.append(newrow)
            del newrow
            del book_type_dict
        #END FOR

        del column_label_list

        matrix_list.sort()

        self.n_log_rows = len(matrix_list)

        #--------------------------------------------------
        self.logtable = QTableWidget(self.n_log_rows,self.n_total_cols)

        self.logtable.setSortingEnabled(False)

        self.logtable.setHorizontalHeaderLabels(sorted_column_label_list)

        self.logtable.setColumnWidth(0, 100)
        self.logtable.setColumnWidth(1, 200)
        self.logtable.setColumnWidth(2, 200)

        self.logtable.clearContents()
        #--------------------------------------------------
        r = 0
        for row in matrix_list:
            try:
                #---------------------------
                #---------------------------
                s_list = row.split("||")
                n_values = len(s_list)
                for i in range(0,n_values):
                    d = s_list[i]
                    if i == 0:
                        d = as_unicode(d)
                    if not isinstance(d,unicode_type):
                        d = as_unicode(d)
                    d_ = QTableWidgetItem(d)
                    self.logtable.setItem(r,i,d_)
                #END FOR
                #--------------------------------------
                r = r + 1
                #--------------------------------------
            except Exception as e:
                if DEBUG: print("class BookIdentifierMatrixDialog(SizePersistedDialog):", as_unicode(e))
                return
        #END FOR
        del d
        del d_
        del s_list

        self.n_total_rows = r

        layout.addWidget(self.logtable)

        self.logtable.sortItems(0,Qt.AscendingOrder )

        self.logtable.setSortingEnabled(True)

        self.resize_all_columns()

        #-----------------------------------------------------

        self.bottom_buttonbox = QDialogButtonBox(QDialogButtonBox.Cancel)
        self.bottom_buttonbox.rejected.connect(self.reject)
        layout.addWidget(self.bottom_buttonbox)

        self.push_button_optimize_column_widths = QPushButton(" ", self)
        self.push_button_optimize_column_widths.setText("Optimize")
        self.push_button_optimize_column_widths.setToolTip("<p style='white-space:wrap'>The listing columns will be resized based on their longest row contents for each column.")
        self.push_button_optimize_column_widths.clicked.connect(self.optimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_optimize_column_widths,0)

        self.push_button_deoptimize_column_widths = QPushButton(" ", self)
        self.push_button_deoptimize_column_widths.setText("Deoptimize")
        self.push_button_deoptimize_column_widths.setToolTip("<p style='white-space:wrap'>The listing columns will be resized to a fixed width regardless of their contents.")
        self.push_button_deoptimize_column_widths.clicked.connect(self.deoptimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_deoptimize_column_widths,0)

        self.push_button_copy_to_clipboard = QPushButton(" ", self)
        self.push_button_copy_to_clipboard.setText("Export to Clipboard")
        self.push_button_copy_to_clipboard.setToolTip("<p style='white-space:wrap'>The Matrix in its entirety will be copied to the Clipboard in a tab-delimited format.  Paste Special into a Spreadsheet, or Paste into a Text Document.")
        self.push_button_copy_to_clipboard.clicked.connect(self.copy_log_to_clipboard)
        self.bottom_buttonbox.addButton(self.push_button_copy_to_clipboard,0)

        self.bottom_buttonbox.setCenterButtons(True)

        #-----------------------------------------------------
        self.resize_dialog()

        self.clip = QApplication.clipboard()

        self.maingui = get_gui()

        self.deoptimize_column_widths()

    #-----------------------------------------------------
    def resize_all_columns(self):
        self.logtable.resizeColumnsToContents()
        self.save_matrix_listing_dialog_geometry()
    #-----------------------------------------------------
    #-----------------------------------------------------
    def optimize_column_widths(self):
        self.logtable.resizeColumnsToContents()
        self.save_matrix_listing_dialog_geometry()
    #-----------------------------------------------------
    def deoptimize_column_widths(self):
        for i in range(0,self.n_total_cols):
            if i > 2:
                self.logtable.setColumnWidth(i, 50)
            else:
                self.logtable.setColumnWidth(i, 100)
        #END FOR
        self.logtable.setColumnWidth(0, 50)

    #-----------------------------------------------------
    def copy_log_to_clipboard(self):
        #tab delimited, ready to "paste special" into Calc or just paste into text document

        self.logtable.selectAll()

        s = ''
        s = s + "\t".join([as_unicode(self.logtable.horizontalHeaderItem(i).text()) for i in range(0, self.n_total_cols)])
        s = s +  '\n'
        for r in range(0, self.n_total_rows):
            for c in range(0, self.n_total_cols):
                try:
                    s = s + as_unicode(self.logtable.item(r,c).text()) + "\t"
                except AttributeError:
                    s = s + "\t"
            s = s[:-1] + "\n"        #eliminate last '\t'
        self.clip.setText(s)

        self.save_matrix_listing_dialog_geometry()
    #-----------------------------------------------------
    def save_matrix_listing_dialog_geometry(self):
        self.dialog_closing(None)
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END OF book_identifier_matrix_listing_dialog.py