# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.190"  #TB Icon Tool: miscellany.

from calibre.customize import InterfaceActionBase

JS_DESCRIPTION = "JS+: Big Tool Box of 68 unique functions to make Calibre better."          # also imported by ui.py for use in action_spec

class ActionBaseJobSpy(InterfaceActionBase):

    name                    = 'Job Spy'
    description           = JS_DESCRIPTION
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 190)
    minimum_calibre_version = (5, 7, 0)    # originally 2.49.0

    actual_plugin       = 'calibre_plugins.job_spy.ui:ActionJobSpy'

    gui_name = 'Job Spy'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.job_spy.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#END of __init__.py