# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.14"  # Miscellany

from PyQt5.Qt import (Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton,
                                       QTextOption, QAbstractScrollArea, QSize, QTextDocument)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs

DEFAULT_WIDTH = 700
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(0, 300)

    def __init__(self, parent, unique_pref_value):
        QDialog.__init__(self, parent)
        self.unique_pref_value = unique_pref_value
        self.geom = gprefs.get(unique_pref_value, None)
        self.finished.connect(self.dialog_closing)

    def resize_dialog(self):
        #~ if DEBUG: self.geom = None
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def dialog_closing(self, result=None):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_value] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class EntitiesViewerDialog(SizePersistedDialog):
    def __init__(self,icon,title,info,font):
        unique_pref_value = 'Manage_Entities:entities_viewer_dialog'
        SizePersistedDialog.__init__(self, None, unique_pref_value)
        #--------------------------------------------------
        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "Entities Manager:  " + title
        if len(title) > DEFAULT_WIDTH - 100:
            title = title[0:DEFAULT_WIDTH - 100]
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.setToolTip("<p style='white-space:wrap'>To save this listing prior to exiting:  Right-Click and 'Select All', 'Copy' to the clipboard, and then paste into a text document.")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.entity_qtextedit =  QTextEdit("")
        self.entity_qtextedit.setReadOnly(True)
        self.entity_qtextedit.setFont(font)
        self.entity_qtextedit.setWordWrapMode(QTextOption.WrapAtWordBoundaryOrAnywhere)
        self.entity_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.AdjustToContents)
        self.entity_qtextedit.setMinimumWidth(DEFAULT_WIDTH)
        self.entity_qtextedit.setMaximumWidth(DEFAULT_WIDTH)
        self.entity_qtextedit.clear()
        self.entity_qtextedit.setHtml(info)
        self.layout.addWidget(self.entity_qtextedit)

        self.resize(self.entity_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.exit_dialog)
        self.layout.addWidget(self.exit_pushbutton)

        self.resize_dialog()
        self.show()
#-----------------------------------------------------------------------------------------
    def exit_dialog(self):
        self.dialog_closing()
        self.hide()
        self.close()
#-----------------------------------------------------------------------------------------
#~ # end of entity_viewer_dialog.py