# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.15"  # Miscellany

from calibre.customize import InterfaceActionBase

#--------------------------------------------------------------------------------------------
class ActionBaseEntitiesManager(InterfaceActionBase):

    name                    = 'Entities Manager'
    description           = 'Associate Calibre Entities to Links, Notes, and other Entities, plus other information independent of any particular book.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 15)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin       = 'calibre_plugins.entities_manager.ui:ActionEntitiesManager'

    gui_name = 'Entities Manager'

    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__.py