# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.14"  # Miscellany

from PyQt5.Qt import Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

NOTE_DEFAULT_WIDTH = 700

#--------------------------------------------------------------------------------------------
class NoteViewerDialog(QDialog):
    def __init__(self,icon,title,note,font):
        super(NoteViewerDialog, self).__init__()

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "Entities Manager:  " + title
        if len(title) > NOTE_DEFAULT_WIDTH - 100:
            title = title[0:NOTE_DEFAULT_WIDTH - 100]
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        font.setBold(False)
        font.setPointSize(11)

        self.setToolTip("<p style='white-space:wrap'>To save this note prior to exiting:  Right-Click and 'Select All', 'Copy' to the clipboard, and then paste into a text document.")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.note_qtextedit =  QTextEdit("")
        self.note_qtextedit.setReadOnly(True)
        self.note_qtextedit.setFont(font)
        self.note_qtextedit.setWordWrapMode(QTextOption.WrapAtWordBoundaryOrAnywhere)
        self.note_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.AdjustToContents)
        self.note_qtextedit.setMinimumWidth(NOTE_DEFAULT_WIDTH)
        self.note_qtextedit.setMaximumWidth(NOTE_DEFAULT_WIDTH)
        self.note_qtextedit.clear()
        self.note_qtextedit.setHtml(note)
        self.layout.addWidget(self.note_qtextedit)

        self.resize(self.note_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)

        self.show()
#~ # end of note_viewer_dialog.py