# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.14"  # Miscellany

from PyQt5.Qt import Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

DEFAULT_WIDTH = 700

#--------------------------------------------------------------------------------------------
class EntityViewerDialog(QDialog):

    def __init__(self,icon,title,info,font):
        super(EntityViewerDialog, self).__init__()

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "Entities Manager:  " + title
        if len(title) > DEFAULT_WIDTH - 100:
            title = title[0:DEFAULT_WIDTH - 100]
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.setToolTip("<p style='white-space:wrap'>To save this entity prior to exiting:  Right-Click and 'Select All', 'Copy' to the clipboard, and then paste into a text document.")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.entity_qtextedit =  QTextEdit("")
        self.entity_qtextedit.setReadOnly(True)
        self.entity_qtextedit.setFont(font)
        self.entity_qtextedit.setWordWrapMode(QTextOption.WrapAtWordBoundaryOrAnywhere)
        self.entity_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.AdjustToContents)
        self.entity_qtextedit.setMinimumWidth(DEFAULT_WIDTH)
        self.entity_qtextedit.setMaximumWidth(DEFAULT_WIDTH)
        self.entity_qtextedit.clear()
        self.entity_qtextedit.setHtml(info)
        self.layout.addWidget(self.entity_qtextedit)

        self.resize(self.entity_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)

        self.show()
#~ # end of entity_viewer_dialog.py