# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.2.1"   # Translations

import os, sys
import sqlite3

from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.utils.logging import Log

from polyglot.builtins import as_unicode, iteritems, unicode_type
from polyglot.queue import Queue

notifications = Queue()
log = Log()

custom_table_string = as_unicode("custom_column_X")
custom_id = 999
books_custom_column_X_link_string = as_unicode("books_custom_column_X_link")
my_terminate_early = False

try:
    load_translations()
except Exception as e:
    if DEBUG: print("author_book_count:  main.py - load_translations() - Exception: ", as_unicode(e))

#~ --------------------------------------------------------------------------
def get_all_author_book_counts(self, my_guidb, log=None, abort=None, notifications=True):

    notifications.put((0.01, _('Counting Author Books')))

    log('====================================================')

    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')

    log(path)

    try:
        my_db = sqlite3.connect(path)
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        log(as_unicode(e))
        return

    my_cursor = my_db.cursor()

    mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
    my_cursor.execute(mysql)

    refresh_author_book_count(my_db,my_cursor,log,notifications)

    my_db.close()

    if not my_terminate_early:
        notifications.put((0.99, _('Counting Author Books')))
        log(' ')
        log(' ')
        log(_('Author Book Count Complete. '))
        log(_('Every book in this library has been updated for ABC. '))
        log(_('Only One Author Per Book Was Counted. '))
        log(' ')
        log(' ')
    else:
        log(_('ABC Terminated'))
#~ --------------------------------------------------------------------------
def refresh_author_book_count(my_db,my_cursor,log,notifications):
    global my_terminate_early
    get_custom_table_name(my_db,my_cursor,log)
    if not my_terminate_early :
        notifications.put((0.02, _('Counting Author Books')))
        drop_standard_calibre_trigger(my_db,my_cursor,log)
        notifications.put((0.03, _('Counting Author Books')))
        refresh_custom_column_x(my_db,my_cursor,log)
        notifications.put((0.10, _('Counting Author Books')))
        refresh_books_custom_column_x(my_db,my_cursor,log)
        notifications.put((0.80, _('Counting Author Books')))
        refresh_optional_abc_numeric(my_db,my_cursor,log)
#~ --------------------------------------------------------------------------
def get_custom_table_name(my_db,my_cursor,log):
    global custom_table_string
    global custom_id
    global books_custom_column_X_link_string
    global my_terminate_early

    custom_table_string = as_unicode("custom_column_X")
    custom_id = 999
    books_custom_column_X_link_string = as_unicode("books_custom_column_X_link")

    mysql = "SELECT id FROM custom_columns WHERE label = 'author_book_count' "
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    if rows is None:
        rows = []
    for row in rows:
        for col in row:
            custom_id = col
            break
        #END FOR
    #END FOR
    del rows

    custom_id_string = as_unicode(custom_id)
    custom_table_string = custom_table_string.replace('X', custom_id_string)
    books_custom_column_X_link_string = books_custom_column_X_link_string.replace('X', custom_id_string)

    if DEBUG: print("custom_table :", custom_table_string, "                           books_custom_column_X_link: ", books_custom_column_X_link_string)

    log(_("custom column table for ABC :         ") + as_unicode(custom_table_string))
    log(_("the cc book link table for ABC:       ") + as_unicode(books_custom_column_X_link_string))

    if custom_table_string == as_unicode("custom_column_999") or custom_table_string == as_unicode("custom_column_X") \
        or books_custom_column_X_link_string == as_unicode("books_custom_column_X_link"):
        log(_("No Custom Table Column author_book_count Configured By User Yet."))
        log(_("Job terminated. Add author_book_count as a custom column.    "))
        if DEBUG: print(_("No Custom Table Column author_book_count Configured By User Yet."))
        if DEBUG: print(_("Job terminated. Add author_book_count as a custom column.    "))
        my_terminate_early = True
#~ --------------------------------------------------------------------------
def refresh_custom_column_x(my_db,my_cursor,log):
    global custom_table_string
    global custom_id

    custom_id_string = as_unicode(custom_id)
    custom_table = as_unicode(custom_table_string)

    mysql = "DELETE FROM " + custom_table + "  "
    my_cursor.execute (mysql)
    my_db.commit()

    mysql = "UPDATE sqlite_sequence SET seq = '1' WHERE name = '" + custom_table + "'"
    my_cursor.execute (mysql)
    my_db.commit()

    mycount = -1  #start at id = 0 in case a user manually updates it to zero

    mysql = "INSERT OR IGNORE INTO custom_column_X(id, value) VALUES (?,?)"
    mysql = mysql.replace('X', custom_id_string)

    while mycount < 10000:
            mycount = mycount + 1
            mycountstr = unicode_type(mycount)
            try:
                my_cursor.execute (mysql,(mycount,mycountstr))
            except Exception as e:
                my_db.close()
                if DEBUG: print(mysql)
                raise e
                return
    #END WHILE

    try:
        my_db.commit()
    except:
        pass
#~ --------------------------------------------------------------------------
def refresh_books_custom_column_x(my_db,my_cursor,log):

    global custom_table_string
    global custom_id
    global books_custom_column_X_link_string

    custom_id_string = as_unicode(custom_id)
    custom_table = as_unicode(custom_table_string)
    books_custom_column_X_link = as_unicode(books_custom_column_X_link_string)

    book_authors_dict = {}  # [bookid] = [authorids]
    authors_books_dict = {} # [authorid] = [bookids]

    if DEBUG: print("Refresh_books_custom_column_x:   custom_table :", custom_table, "    books_custom_column_X_link: ", books_custom_column_X_link)

    mysql = "DELETE FROM " + books_custom_column_X_link + "   "
    my_cursor.execute (mysql)
    my_db.commit()

    mysql = "UPDATE sqlite_sequence SET seq = '1' WHERE name = '" + books_custom_column_X_link + "'"
    my_cursor.execute (mysql)
    my_db.commit()

    mysql = "SELECT book, author FROM books_authors_link WHERE id IS NOT NULL AND author IS NOT NULL ORDER BY book, author;"
    my_cursor.execute (mysql)
    tmp_rows = my_cursor.fetchall()
    if tmp_rows is None:
        tmp_rows = []
    for row in tmp_rows:
        book,author = row
        if book in book_authors_dict:
            author_list = book_authors_dict[book]
            author_list.append(author)
            book_authors_dict[book] = author_list
        else:
            author_list = []
            author_list.append(author)
            book_authors_dict[book] = author_list
        if author in authors_books_dict:
            book_list = authors_books_dict[author]
            book_list.append(book)
            authors_books_dict[author] = book_list
        else:
            book_list = []
            book_list.append(book)
            authors_books_dict[author] = book_list
    #END FOR

    author_book_count_dict = {} # [authorid] = book_count

    for author,book_list in iteritems(authors_books_dict):
        author_book_count_dict[author] = len(book_list)
    #END FOR

    book_first_author_dict = {}  # [bookid] = first author id

    for book,author_list in iteritems(book_authors_dict):
        if isinstance(author_list,list):
            if len(author_list) > 0:
                first_author = author_list[0]
                book_first_author_dict[book] = first_author
            else:
                if DEBUG: print("error: ", as_unicode(book), "  has no authors in author_list...")
                continue
    #END FOR

    mysql = "INSERT OR IGNORE INTO " + books_custom_column_X_link + " (id, book, value) VALUES (?,?,?)"

    for book,first_author in iteritems(book_first_author_dict):
        if first_author in author_book_count_dict:
            count = author_book_count_dict[first_author]
            count = int(count)  # value is the integer id of the main table with the value == count...
            book = int(book)
            my_cursor.execute(mysql,(None,book,count))
        else:
            if DEBUG: print("first_author not in author_book_count_dict: ", first_author)
            continue
    #END FOR

    try:
        my_db.commit()
    except:
        pass

    del tmp_rows
    del book_authors_dict
    del authors_books_dict
    del book_first_author_dict
    del author_book_count_dict
#~ --------------------------------------------------------------------------
def refresh_optional_abc_numeric(my_db,my_cursor,log):
    #if the custom column abc_numeric exits, populate it as an integer, not text
    #this will enable purely numeric search criteria and regular expressions.
    #if the custom column does not exist, then nothing will be done.  optional

    global custom_table   #author_book_count custom column
    global custom_id
    global books_custom_column_X_link_string     #author_book_count custom column book link

    numeric_custom_table_string = as_unicode("custom_column_X")
    numeric_custom_id = 999

    try:
        mysql = "SELECT id FROM custom_columns WHERE label = 'abc_numeric' "
        my_cursor.execute (mysql)
        rows = my_cursor.fetchall()
        if rows is not None:
            if len(rows) == 0:
                return
            for row in rows:
                for col in row:
                    numeric_custom_id = col
                    break
            #END FOR

            numeric_custom_id_string = as_unicode(numeric_custom_id)
            numeric_custom_table_string = numeric_custom_table_string.replace('X', numeric_custom_id_string)

            if numeric_custom_table_string == as_unicode("custom_column_999") or numeric_custom_table_string == as_unicode("custom_column_X"):
                log(_("No special integer-type 'abc_numeric' custom column table for ABC exists; no 'abc_numeric' could be updated.  "))
                return
        else:
            return

        try:
            mysql = "DELETE FROM " + numeric_custom_table_string + " WHERE id >= 0;"
            my_cursor.execute (mysql)
            my_db.commit()
            mysql = "INSERT OR IGNORE INTO " + numeric_custom_table_string + "  (id, book, value) SELECT * FROM " + books_custom_column_X_link_string + "  "
            my_cursor.execute (mysql)
            my_db.commit()
            log("Special integer-type 'abc_numeric' custom column table for ABC was updated: " + numeric_custom_table_string)
        except:
            return
    except:
        return
#~ --------------------------------------------------------------------------
def drop_standard_calibre_trigger(my_db,my_cursor,log):
        global custom_id
        custom_id_string = as_unicode(custom_id)
        #this automatically Calibre-created trigger should never be executed because custom_column_X should never become empty given its nature and purpose.
        #this trigger will purge books_custom_column_X_link when custom_column_x is emptied and rebuilt. So, DROP it.
        mysql = "SELECT COUNT(*) from sqlite_master WHERE type = 'trigger' AND name = 'fkc_delete_books_custom_column_X_link' "
        mysql = mysql.replace('X', custom_id_string)
        my_cursor.execute (mysql)
        result = my_cursor.fetchone()
        number_of_rows = result[0]
        if number_of_rows != 0:
            mysql = "DROP TRIGGER fkc_delete_books_custom_column_X_link"
            mysql = mysql.replace('X', custom_id_string)
            my_cursor.execute (mysql)
            my_db.commit()
#~ --------------------------------------------------------------------------
#END of main.py