# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.16"  # Miscellany

from calibre.customize import InterfaceActionBase

class ActionAuditLog(InterfaceActionBase):

    name                    = 'Audit Log'
    description           = "Undo/Reverse most metadata deletes and updates weeks later for selected books and log entries.  Creates a log entry for every addition, change or delete for most Calibre standard metadata columns, and for all custom metadata columns."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 16)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin       = 'calibre_plugins.audit_log.ui:ActionAuditLog'

    gui_name = 'Audit Log'

   #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.audit_log.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#END of __init__py