#!/bin/sh
#Symbola14.sh:
#Compare version14 of George Douros's notorious OpenType font to NiLuJe's BLOCK fixed size font

cd /mnt/us
fd=/mnt/us/fonts/
s1="◢██◤█  █◥██◣◥██◣◥██◣█   ◢██◣
◥◣  ◥◣◢◤█◤◤██ ◢◤█  ██   █  █
  ◥◣ █◤ █  ██ ◥◣█  ██  ◢██◣█
◥██◤◢◤  ◤  ◤◥██◤◥██◤◤██◤◥  ◤"

s2="🮞🮐🮐🮜🮐  🮐🮝🮐🮐🮟🮝🮐🮐🮟🮝🮐🮐🮟🮐   🮞🮐🮐🮟
🮝🮟  🮝🮟🮞🮜🮐🮜🮜🮐🮐 🮞🮜🮐  🮐🮐   🮐  🮐
  🮝🮟 🮐🮜 🮐  🮐🮐 🮝🮟🮐  🮐🮐  🮞🮐🮐🮟🮐
🮝🮐🮐🮜🮞🮜  🮜  🮜🮝🮐🮐🮜🮝🮐🮐🮜🮜🮐🮐🮜🮝  🮜"

#keep the Kindle quiet
lipc-set-prop com.lab126.powerd preventScreenSaver 1
killall -stop cvm # pause framework

portrait=3 #K3=0, PW3=3 PW4=3
landscape=0 #K3=1, PW3=0 PW4=0
fbdepth -q -r $landscape
fbink -c #clear background

fbink -t regular="$fd"symbola.otf,px=15,top=10,left=10  -m -O   -C gray7 "$s1"
fbink -t regular="$fd"symbola.otf,px=15,top=0 -m -O "$s1"

fbink -t regular="$fd"symbola.otf,px=30,top=85,left=10  -m -O   -C gray7 "$s1"
fbink -t regular="$fd"symbola.otf,px=30,top=75 -m -O "$s1"

fbink -t regular="$fd"symbola.otf,px=45,top=215,left=10  -m -O   -C gray7 "$s1"
fbink -t regular="$fd"symbola.otf,px=45,top=205 -m -O "$s1"

fbink -F BLOCK -m -S 5 -O  -C gray7 -X 10 -Y 380 "BLOCK"
fbink -F BLOCK -m -S 5 -O -Y 370 "BLOCK"

fbink -F BLOCK -m -S 4 -O  -C gray7 -X 10 -Y 545 "BLOCK"
fbink -F BLOCK -m -S 4 -O -Y 535 "BLOCK"

fbink -F BLOCK -m -S 3 -O  -C gray7 -X 10 -Y 683 "BLOCK"
fbink -F BLOCK -m -S 3 -O -Y 673 "BLOCK"
                                                                                           
#save for posting
fbgrab fbgrab.png #grab a screenshot

#restore the Kindle activity
fbdepth -q -r $portrait
killall -cont cvm;
lipc-set-prop com.lab126.powerd preventScreenSaver 0