#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
from __future__ import absolute_import
from __future__ import print_function
from calibre.customize import InterfaceActionBase

__license__ = 'GPL v3'
__copyright__ = "Copyright 2015-2021"
__author__ = "Michael Dinkelaker"
__email__ = "michael.dinkelaker@gmail.com"
__docformat__ = 'restructuredtext en'
__version__ = (1,5,3)

load_translations()


class ActionPrettifyCover(InterfaceActionBase):

    name = 'Prettify Cover'
    description = _('Scale book-covers proportional to the size of '
                    'e-readers screen.')
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Michael Dinkelaker'
    version = __version__
    minimum_calibre_version = (2, 0, 0)

    actual_plugin = 'calibre_plugins.prettify_cover.action:PrettifyCoverAction'

    def is_customizable(self):
        return True

    def config_widget(self):
        if self.actual_plugin_:
            from calibre_plugins.prettify_cover.config import ConfigWidget
            return ConfigWidget(self.actual_plugin_)

    def save_settings(self, config_widget):
        config_widget.save_settings()
        if self.actual_plugin_:
            self.actual_plugin_.rebuild_menus()
