#!/bin/sh
#
##

HACKNAME="touchblock"

# Pull libOTAUtils for logging & progress handling
[ -f ./libotautils5 ] && source ./libotautils5

HACKVER="1.0"

CONFIG_FILE="/etc/deviceConfig.conf"
CONFIG_FILE_BACKUP="/etc/deviceConfig.conf.bak"
CONFIG_FILE_MD5="ecc8818ba367fd199a227d386b8f70f3"

# Result codes
OK=0
ERR=1

otautils_update_progressbar

# Check if backup file exists and does meet our md5 expectations:
if [ -f $CONFIG_FILE_BACKUP ] && [ "$(md5sum $CONFIG_FILE_BACKUP | head -c32)" = "$CONFIG_FILE_MD5" ]; then
    logmsg "I" "install" "" "$CONFIG_FILE_BACKUP md5sum correct, proceeding with installation"
else
    logmsg "C" "install" "" "md5sum mismatch, bailing out: $(md5sum $CONFIG_FILE_BACKUP | head -c32) != $CONFIG_FILE_MD5"
    return ${ERR}
fi

otautils_update_progressbar

# Mount root rw
if ! mntroot rw; then
    logmsg "C" "install" "code=$?" "Unable to mount root rw"
    return ${ERR}
fi

otautils_update_progressbar

# Restore original config file
if ! mv $CONFIG_FILE_BACKUP $CONFIG_FILE; then
    logmsg "C" "install" "code=$?" "Unable to restore original config file"
    return ${ERR}
fi

otautils_update_progressbar

# Mount root ro
if ! mntroot ro; then
    logmsg "W" "install" "code=$?" "Unable to mount root ro"
fi

otautils_update_progressbar

return ${OK}