#!/bin/sh
#
##

HACKNAME="touchblock"

# Pull libOTAUtils for logging & progress handling
[ -f ./libotautils5 ] && source ./libotautils5

HACKVER="1.0"

CONFIG_FILE="/etc/deviceConfig.conf"
CONFIG_FILE_BACKUP="/etc/deviceConfig.conf.bak"
CONFIG_FILE_MD5="ecc8818ba367fd199a227d386b8f70f3"

CONFIG_FILE_DECRYPTED="/tmp/deviceConfigDecrypted.conf"
CONFIG_FILE_NEW_MD5="7193d166a3d235cb3b01043981c1830f"

UPSTART_SCRIPT="xbath.conf"
UPSTART_PATH="/etc/upstart/"

# Result codes
OK=0
ERR=1

otautils_update_progressbar

# Check if original file does meet our md5 expectations:
if [ "$(md5sum $CONFIG_FILE | head -c32)" = "$CONFIG_FILE_MD5" ]; then
    logmsg "I" "install" "" "$CONFIG_FILE md5sum correct, proceeding with installation"
else
    logmsg "C" "install" "" "md5sum mismatch, bailing out: $(md5sum $CONFIG_FILE | head -c32) != $CONFIG_FILE_MD5"
    return ${ERR}
fi

otautils_update_progressbar

# Decrypt the configuration file
if ! devcap-encrypt -i $CONFIG_FILE $CONFIG_FILE_DECRYPTED; then
    logmsg "C" "install" "code=$?" "Unable to decrypt $CONFIG_FILE"
    return ${ERR}
fi

otautils_update_progressbar

# Update decrypted file content
if ! sed -i 's/\[common\]/\[common\]\nwaterproof.available=true/g' $CONFIG_FILE_DECRYPTED; then
    logmsg "C" "install" "code=$?" "Unable to update $CONFIG_FILE_DECRYPTED"
    return ${ERR}
fi

otautils_update_progressbar

# Check if new file checksum is correct
if [ "$(md5sum $CONFIG_FILE_DECRYPTED | head -c32)" = "$CONFIG_FILE_NEW_MD5" ]; then
    logmsg "I" "install" "" "$CONFIG_FILE_DECRYPTED md5sum correct, proceeding with installation"
else
    logmsg "C" "install" "" "md5sum mismatch, bailing out: $(md5sum $CONFIG_FILE_DECRYPTED | head -c32) != $CONFIG_FILE_NEW_MD5"
    return ${ERR}
fi

otautils_update_progressbar

# Mount root rw
if ! mntroot rw; then
    logmsg "C" "install" "code=$?" "Unable to update mount root rw"
    return ${ERR}
fi

otautils_update_progressbar

# Backup original config file
if ! cp $CONFIG_FILE $CONFIG_FILE_BACKUP; then
    logmsg "C" "install" "code=$?" "Unable to backup original config file"
    return ${ERR}
fi

otautils_update_progressbar

# Install the new config
if ! devcap-encrypt -i $CONFIG_FILE_DECRYPTED $CONFIG_FILE; then
    logmsg "C" "install" "code=$?" "Unable install new, encrypted file"
    return ${ERR}
fi

otautils_update_progressbar

# Install the new upstart file
if ! cp $UPSTART_SCRIPT "${UPSTART_PATH}${UPSTART_SCRIPT}"; then
    logmsg "C" "install" "code=$?" "Unable install new, encrypted file"
    return ${ERR}
fi

otautils_update_progressbar

# Mount root ro
if ! mntroot ro; then
    logmsg "W" "install" "code=$?" "Unable to mount root ro"
fi

otautils_update_progressbar

return ${OK}
