// BBeBMetaData.cpp : Implementation of CBBeBMetaData
#include "stdafx.h"
//#include "BBeB.h"
#include "BBeBMetaData.h"

#define GET_DWORD_BE(ptr) (DWORD)( \
	((unsigned char*)(ptr))[3]       | \
	((unsigned char*)(ptr))[2] << 8  | \
	((unsigned char*)(ptr))[1] << 16 | \
((unsigned char*)(ptr))[0] << 24 )

#define GET_WORD_BE(ptr) (WORD)( \
	((unsigned char*)(ptr))[1]       | \
((unsigned char*)(ptr))[0] << 8 )

#define GET_WORD_LE(ptr) (WORD)( \
	((unsigned char*)(ptr))[0]       | \
((unsigned char*)(ptr))[1] << 8 )

typedef unsigned char  Bytef;
typedef unsigned long  uLong;
typedef unsigned long uLongf;
typedef unsigned int   uInt;
struct internal_state;

typedef struct z_stream_s {
	Bytef    *next_in;  /* next input byte */
	uInt     avail_in;  /* number of bytes available at next_in */
	uLong    total_in;  /* total nb of input bytes read so far */
	
	Bytef    *next_out; /* next output byte should be put there */
	uInt     avail_out; /* remaining free space at next_out */
	uLong    total_out; /* total nb of bytes output so far */
	
	char     *msg;      /* last error message, NULL if no error */
	struct internal_state FAR *state; /* not visible by applications */
	
	void*    zalloc;  /* used to allocate the internal state */
	void*    zfree;   /* used to free the internal state */
	void*    opaque;  /* private data object passed to zalloc and zfree */
	
	int     data_type;  /* best guess about the data type: ascii or binary */
	uLong   adler;      /* adler32 value of the uncompressed data */
	uLong   reserved;   /* reserved for future use */
} z_stream;

typedef z_stream* z_streamp;

#define Z_BUF_ERROR    (-5)
#define Z_FINISH        4
#define Z_STREAM_END    1
#define Z_OK            0
#define Z_NEED_DICT     2
#define Z_DATA_ERROR   (-3)
#define ZEXTERN extern __declspec(dllimport)
#define ZEXPORT WINAPI
#define ZLIB_VERSION "1.2.3"

extern "C"{
ZEXTERN int inflateInit_(z_streamp strm, const char *version, int stream_size);
ZEXTERN int inflate(z_streamp strm, int flush);
ZEXTERN int inflateEnd(z_streamp strm);
}

#define inflateInit(strm) inflateInit_((strm), ZLIB_VERSION, sizeof(z_stream))

int uncompress(Bytef *dest, uLongf *destLen, const Bytef *source, uLong sourceLen)
{
	z_stream stream;
	int err;
	
	stream.next_in = (Bytef*)source;
	stream.avail_in = (uInt)sourceLen;
	/* Check for source > 64K on 16-bit machine: */
	if ((uLong)stream.avail_in != sourceLen) return Z_BUF_ERROR;
	
	stream.next_out = dest;
	stream.avail_out = (uInt)*destLen;
	if ((uLong)stream.avail_out != *destLen) return Z_BUF_ERROR;
	
	stream.zalloc = 0;
	stream.zfree = 0;
	
	err = inflateInit(&stream);
	if (err != Z_OK) return err;
	
	err = inflate(&stream, Z_FINISH);
	if (err != Z_STREAM_END) {
		inflateEnd(&stream);
		if (err == Z_NEED_DICT || (err == Z_BUF_ERROR && stream.avail_in == 0))
			return Z_DATA_ERROR;
		return err;
	}
	*destLen = stream.total_out;
	
	err = inflateEnd(&stream);
	return err;
}

struct LrfMetaData
{
	CComBSTR Title, Author;
};

#define AUTHOR L"Author"
#define AUTHORLEN (sizeof(AUTHOR)/2)-1
#define TITLE L"Title"
#define TITLELEN (sizeof(TITLE)/2)-1
bool parseMetaData(const Bytef* data, DWORD size, LrfMetaData& metadata)
{
	if (size<2 || GET_WORD_LE(data)!=0xFEFF)
		return false;
	wchar_t* ptr = (wchar_t*)(data+2);
	size =(size-2)/2;
	int cnt=0;
	while (size && cnt<2)
	{
		while (size-- && *ptr!=L'<') ptr++;
		if (!size || *ptr!=L'<')
			return false;
		ptr++;
		if (CompareString(LOCALE_NEUTRAL, 0, ptr, AUTHORLEN, AUTHOR, AUTHORLEN)==CSTR_EQUAL)
		{
			//parse author
			while (size-- && *ptr!=L'>') ptr++;
			if (!size || *ptr!=L'>')
				return false;
			ptr++;
			wchar_t* ptr2 = ptr;//start of string
			while (size-- && *ptr!=L'<') ptr++;
			if (!size || *ptr!=L'<')
				return false;
			*ptr=0;
			metadata.Author = ptr2;
			cnt++;
		}
		else if (CompareString(LOCALE_NEUTRAL, 0, ptr, TITLELEN, TITLE, TITLELEN)==CSTR_EQUAL)
		{
			//parse author
			while (size-- && *ptr!=L'>') ptr++;
			if (!size || *ptr!=L'>')
				return false;
			ptr++;
			wchar_t* ptr2 = ptr;//start of string
			while (size-- && *ptr!=L'<') ptr++;
			if (!size || *ptr!=L'<')
				return false;
			*ptr=0;
			metadata.Title = ptr2;
			cnt++;
		}
	}
	return true;
}

bool getLrfMetaData(LPCOLESTR pszFileName, LrfMetaData& metadata)
{
	HANDLE hInputFile = CreateFile(pszFileName, FILE_READ_DATA, FILE_SHARE_DELETE|FILE_SHARE_READ|FILE_SHARE_WRITE,
		NULL, OPEN_EXISTING, 0, NULL);
	if (hInputFile==INVALID_HANDLE_VALUE)
		return false;
	
	Bytef* compData=0;
	Bytef* uncompData=0;

	__try{
		BYTE buf[16];
		DWORD bytesRead;
		DWORD offset = 0;
		if (0==ReadFile(hInputFile, buf, 16, &bytesRead, NULL) || bytesRead!=16)
			return false;
		if (0==memcmp(buf+4, "ftypLRX2", 8))
		{	
			//Reader LRX
			//skip to the embedded LRF
			do {
				offset += GET_DWORD_BE(buf);
				if (offset!=SetFilePointer(hInputFile, offset, NULL, SEEK_SET))
					return false;
				if (0==ReadFile(hInputFile, buf, 8, &bytesRead, NULL) || bytesRead!=8)
					return false;
			}
			while (memcmp(buf+4, "bbeb", 4));
			//skip the chunk header
			offset+=8;
			SetFilePointer(hInputFile, offset, NULL, SEEK_SET);
			//read in the LRF header
			if (0==ReadFile(hInputFile, buf, 16, &bytesRead, NULL) || bytesRead!=16)
				return false;
		}
		else if (0==memcmp(buf+4, "LRX", 4))
		{
			//Librie LRX
			//offset to the LRF is at offset 14h
			SetFilePointer(hInputFile, 0x14, NULL, SEEK_SET);
			if (0==ReadFile(hInputFile, &offset, 4, &bytesRead, NULL) || bytesRead!=4)
				return false;
			SetFilePointer(hInputFile, offset, NULL, SEEK_SET);
			//read in the LRF header
			if (0==ReadFile(hInputFile, buf, 16, &bytesRead, NULL) || bytesRead!=16)
				return false;
		}
		if (memcmp(buf, L"LRF", 8))
			return false;//not an LRF
		WORD lrfVer = GET_WORD_LE(buf+8);
		//seek to metainfo size
		SetFilePointer(hInputFile, offset+0x4C, NULL, SEEK_SET);
		WORD compSize;
		DWORD uncompSize;
		if (0==ReadFile(hInputFile, &compSize, 2, &bytesRead, NULL) || bytesRead!=2)
			return false;
		if (lrfVer>=800)
			//skip the thumbnail info
			SetFilePointer(hInputFile, 6, NULL, SEEK_CUR);
		if (0==ReadFile(hInputFile, &uncompSize, 4, &bytesRead, NULL) || bytesRead!=4)
			return false;
		compSize-=4;
		compData = (Bytef*)malloc(compSize);
		if (0==ReadFile(hInputFile, compData, compSize, &bytesRead, NULL) || bytesRead!=compSize)
			return false;
		uncompData = (Bytef*)malloc(uncompSize);
		bytesRead = uncompSize;
		if (uncompress(uncompData, &bytesRead, compData, compSize)!=Z_OK || bytesRead!=uncompSize)
			return false;
		free(compData);
		compData=0;
		return parseMetaData(uncompData, uncompSize, metadata);
	}
	__finally{
		free(compData);
		free(uncompData);
		CloseHandle(hInputFile);
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////
// CBBeBMetaData

HRESULT STDMETHODCALLTYPE CBBeBMetaData::Load(LPCOLESTR pszFileName, DWORD dwMode)
{
	if (pszFileName == NULL)
		return E_POINTER;
	if (INVALID_FILE_ATTRIBUTES==GetFileAttributes(pszFileName))
		return E_FAIL;
	LrfMetaData metadata;
	if (!getLrfMetaData(pszFileName, metadata))
		return E_FAIL;
	if (m_curFilename == pszFileName)
		return S_OK;
	m_curFilename = pszFileName;
	if (m_curPropSetStorage) m_curPropSetStorage->Release();
	m_curPropSetStorage = 0;
	{
		ILockBytes* LockBytes=0;
		IStorage* Storage=0;
		HRESULT hr = CreateILockBytesOnHGlobal(0, TRUE, &LockBytes);
		if FAILED(hr)
			return E_FAIL;
		hr = StgCreateDocfileOnILockBytes(LockBytes, 
			STGM_READWRITE | STGM_SHARE_EXCLUSIVE | STGM_CREATE, 0, &Storage);			
		if (LockBytes) LockBytes->Release();
		if FAILED(hr) 
		{
			return E_FAIL;
		}
		hr = StgCreatePropSetStg(Storage, 0, &m_curPropSetStorage);
		if (Storage) Storage->Release();
		if (FAILED(hr) || m_curPropSetStorage==0)
		{
			return E_FAIL;
		}
		IPropertyStorage* summaryPropStg=0; 
		hr = m_curPropSetStorage->Create(FMTID_SummaryInformation, 0, PROPSETFLAG_DEFAULT, 
			STGM_CREATE | STGM_READWRITE | STGM_SHARE_EXCLUSIVE, &summaryPropStg);
		if (FAILED(hr) || summaryPropStg==0)
		{
			m_curPropSetStorage->Release();
			m_curPropSetStorage=0;
			return E_FAIL;
		}
		if (summaryPropStg)
		{
			PROPSPEC specs[2];
			PROPVARIANT vals[2];
			specs[0].ulKind = PRSPEC_PROPID;
			specs[0].propid = PIDSI_TITLE;
			specs[1].ulKind = PRSPEC_PROPID;
			specs[1].propid = PIDSI_AUTHOR;
			PropVariantInit(vals);
			PropVariantInit(vals+1);
			vals[0].vt = vals[1].vt = VT_LPWSTR;
			vals[0].pwszVal = metadata.Title; //L"BBeB title";
			vals[1].pwszVal = metadata.Author; //L"BBeB author";
			hr = summaryPropStg->WriteMultiple(2, specs, vals, PID_FIRST_USABLE);
			if FAILED(hr)
			{
				summaryPropStg->Release();
				m_curPropSetStorage->Release();
				m_curPropSetStorage=0;
				return E_FAIL;
			}
			//summaryPropStg->Commit(STGC_DEFAULT);
			summaryPropStg->Release();
		}
	}
	return m_curPropSetStorage?S_OK:E_FAIL;
}
