from calibre_plugins.tematika_pricecheck.config import prefs


def pcheck(mi, pricecount, dtable, col):
    from datetime import datetime
    date_col = prefs['date_column']
    adddate = True
    ids = mi.identifiers
    isbn = ''
    
    #Get isbn from identifiers dict
    for k, v in ids.items():
        if k == "isbn":
            isbn = v
    
    coldata = mi.get(col)
    if not prefs['update'] and coldata != None:
        print(coldata)
        print("no update")
        return mi, pricecount, dtable
    if isbn != '':
        price = scrape(isbn)
        if price != None:
            mi.set(col,price)
            pricecount += 1
        else:
            price = "Not found"
            cur_date = mi.get(date_col)
            if cur_date == None:
                adddate = False
            else:
                print(cur_date)
    else:
        adddate = False
        isbn = "Not found"
        price = "N/A"
    dtable.append([mi.title, isbn, price])
    return mi, pricecount, dtable, adddate

def scrape(isbn):
    from bs4 import BeautifulSoup as bs
    import requests
    url = "https://www.tematika.com/catalogsearch/result/?q=" + isbn
    r = requests.get(url)
    soup = bs(r.text, 'html.parser')
    div = soup.find(id='jm-current-content')
    try:
        pricebox = div.find_all(class_="price-box")
        if len(pricebox) == 1:
            for p in pricebox:
                pricespan = p.find(class_="price")
                return pricespan.text
        else:
            return None
    except:
        return None