#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai


__license__   = 'GPL v3'
__copyright__ = '2011, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'

from qt.core import QWidget, QHBoxLayout, QLabel, QLineEdit, QCheckBox

from calibre.utils.config import JSONConfig

# This is where all preferences for this plugin will be stored
# Remember that this name (i.e. plugins/interface_demo) is also
# in a global namespace, so make it as unique as possible.
# You should always prefix your config file name with plugins/,
# so as to ensure you dont accidentally clobber a calibre config file
prefs = JSONConfig('plugins/tematika_pricecheck')

# Set defaults
prefs.defaults['update'] = False
prefs.defaults['custom_column'] = ''
prefs.defaults['date_column'] = ''


class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        self.l = QHBoxLayout()
        self.setLayout(self.l)
        
        self.update_box = QCheckBox(
            'Update prices')
        self.update_box.setChecked(prefs['update'])
        self.l.addWidget(self.update_box)

        self.label = QLabel('Price Column name')
        self.l.addWidget(self.label)

        self.msg = QLineEdit(self)
        self.msg.setText(prefs['custom_column'])
        self.l.addWidget(self.msg)
        self.label.setBuddy(self.msg)

        self.label2 = QLabel('Date Column name')
        self.l.addWidget(self.label2)

        self.msg2 = QLineEdit(self)
        self.msg2.setText(prefs['date_column'])
        self.l.addWidget(self.msg2)
        self.label2.setBuddy(self.msg2)
    def save_settings(self):
        prefs['update'] = self.update_box.isChecked()
        prefs['custom_column'] = self.msg.text()
        prefs['date_column'] = self.msg2.text()
