/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class NewJFrame
extends JFrame {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextField1;
    public ArrayList<Annotation> highlightList = new ArrayList();
    public ArrayList<Annotation> noteList = new ArrayList();
    public File myClippings;
    public File originalHTML;
    public File outputHTML;
    public String title;

    public NewJFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton4 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.jButton1.setText("MyClippings file");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("HTML File to Highlight");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText(" ");
        this.jLabel2.setText(" ");
        this.jButton3.setText("HTML File to Save");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel3.setText(" ");
        this.jButton4.setText("Process File");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jTextField1.setHorizontalAlignment(0);
        this.jTextField1.setText("Title of Work as in Myclippings.txt");
        this.jLabel4.setText("Highlights: ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(4).add(this.jLabel3).add(this.jButton3).add(this.jLabel2).add(this.jButton2).add(this.jLabel1).add(this.jButton1).add(this.jTextField1, -1, 471, Short.MAX_VALUE))).add(layout.createSequentialGroup().add(80, 80, 80).add(this.jButton4).add(85, 85, 85).add(this.jLabel4))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(27, 27, 27).add(this.jButton1).addPreferredGap(0).add(this.jLabel1).addPreferredGap(0).add(this.jButton2).addPreferredGap(0).add(this.jLabel2).addPreferredGap(0).add(this.jButton3).addPreferredGap(0).add(this.jLabel3).addPreferredGap(0).add(this.jTextField1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButton4).add(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        try {
            this.title = this.jTextField1.getText();
            this.importNotes();
            this.highlightText();
            for (int i = 0; i < this.highlightList.size(); ++i) {
                System.out.println("___________________________________");
                System.out.println("Highlight in " + this.title + " at location(s) " + this.highlightList.get(i).getLocation());
                System.out.println(this.highlightList.get(i).getValue());
            }
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showOpenDialog(this.jButton1);
        this.myClippings = this.jFileChooser1.getSelectedFile();
        this.jLabel1.setText(this.jFileChooser1.getSelectedFile().toString());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showOpenDialog(this.jButton1);
        this.originalHTML = this.jFileChooser1.getSelectedFile();
        this.jLabel2.setText(this.jFileChooser1.getSelectedFile().toString());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showSaveDialog(this.jButton1);
        this.outputHTML = this.jFileChooser1.getSelectedFile();
        this.jLabel3.setText(this.jFileChooser1.getSelectedFile().toString());
    }

    private void addHighlight(String techInfo, String value) {
        Scanner scanTech = new Scanner(techInfo);
        String location = scanTech.findInLine("Loc. \\d+-*\\d*").replace("Loc. ", "");
        String date = scanTech.findInLine("Added on .*").replace("Added on ", "");
        this.highlightList.add(new Annotation("Highlight", location, value, date));
    }

    private void addNote(String techInfo, String value) {
        Scanner scanTech = new Scanner(techInfo);
        String location = scanTech.findInLine("Loc. \\d+-?\\d*?").replace("Loc. ", "");
        String date = scanTech.findInLine("Added on *M").replace("Added on ", "");
        this.noteList.add(new Annotation("Highlight", location, value, date));
    }

    private void highlightText() throws FileNotFoundException, UnsupportedEncodingException {
        Scanner scanner1 = new Scanner(this.originalHTML, "UTF-8");
        scanner1.useDelimiter("/Z");
        String htmlText = scanner1.next();
        for (int i = 0; i < this.highlightList.size(); ++i) {
            Scanner scan = new Scanner(this.originalHTML);
            String stringToHighlight = scan.findInLine(this.highlightList.get(i).getHtmlValue());
            if (stringToHighlight.startsWith(">")) {
                System.out.println(this.highlightList.get(i).getHtmlValue());
                htmlText = htmlText.replace(stringToHighlight, "<span style=\"background-color:#FFFF00; border:#FFFF00 solid\"" + stringToHighlight + "</span>");
            } else if (stringToHighlight.endsWith("<")) {
                System.out.println(this.highlightList.get(i).getHtmlValue());
                htmlText = htmlText.replace(stringToHighlight, "<span style=\"background-color:#FFFF00; border:#FFFF00 solid\">" + stringToHighlight + "></span");
            } else {
                System.out.println(this.highlightList.get(i).getHtmlValue());
                htmlText = htmlText.replace(stringToHighlight, "<span style=\"background-color:#FFFF00; border:#FFFF00 solid\">" + stringToHighlight + "</span>");
            }
            this.jLabel4.setText("Highlights: " + i);
        }
        PrintStream out = new PrintStream(this.outputHTML);
        out.print(htmlText);
    }

    private void importNotes() throws FileNotFoundException {
        Scanner scan = new Scanner(this.myClippings, "UTF-8");
        while (scan.hasNext()) {
            if (!scan.nextLine().contains(this.title)) continue;
            String techInfo = scan.nextLine();
            scan.nextLine();
            String value = scan.nextLine();
            if (techInfo.contains("Highlight")) {
                this.addHighlight(techInfo, value);
                continue;
            }
            if (!techInfo.contains("Note")) continue;
            this.addNote(techInfo, value);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new NewJFrame().setVisible(true);
            }
        });
    }
}

