import clock
import layers
import kindleStates

from imageUtils import imageCycle
import printScreen
import extraUtils

from config import conf as CONFIG

# Some Global Variables
## Image
background_image = imageCycle.ordered()
image = object()

## Toggles
screensaver_layer_state = 0
power_state = 0

## Timers
task_one_timer = clock.Timer(CONFIG["task_one_timer"])
task_two_timer = clock.Timer(CONFIG["task_two_timer"])
state_check_timer = clock.Timer(CONFIG["state_check_timer"]) # a battery saving measures


while True:
    clock.Timer.timer_update()

    if state_check_timer.timer_check("State Check Timer"):
        print("\Checking State")
        screensaver_layer_state=kindleStates.check_screensaver_layer()
        power_state = kindleStates.check_power_state()

    if screensaver_layer_state and power_state: 
        if task_one_timer.timer_check("Task One Timer"): 
            print("\nRunning Task One")
            background_image = imageCycle.ordered()
            extraUtils.refresh_screen_once("Reset")
                    
        if task_two_timer.timer_check("Task Two Timer",True): 
            print("\nRunning Task Two")
            image = layers.Layers.generate_background(background_image,CONFIG)
            image = layers.Topbar.generate_topbar(image,CONFIG)
            image = layers.WidgetForSchedule.generate_module(image,CONFIG)
            
            # image = layers.Layers.gray_scale(image)

            # Final check for screensaver state before display
            if kindleStates.check_screensaver_layer():
                try:
                    # returns an exemption if not on a kindle
                    # raise
                    # clock.Timer.loop_speed_limiter(1000) 
                    extraUtils.delay_screensaver_timeout()
                    printScreen.print_kindle_screen(image)
                    extraUtils.refresh_screen_once()
                    # extraUtils.adjustLightIntensity(1)
                except:
                    layers.display_image(image)
                    break
    else: 
        clock.Timer.loop_speed_limiter(2000) # extra delay to save battery
        extraUtils.refresh_screen_once("Reset")
        # extraUtils.adjustLightIntensity(0)
 
    # Battery saving measure; also makes terminal readable; min loop speed in ms
    clock.Timer.loop_speed_limiter(1000) 
    

 
