import subprocess

def screenFlash():
    try:
        subprocess.run(["fbink","-q", "-f", "-s"])
    except:
        print("screenFlash() failed...")

        
def print_kindle_screen(theImage):


    # practically Niluje's code below

    # Load the wrapper module, it's linked against FBInk, so the dynamic loader will take care of pulling in the actual FBInk library
    from _fbink import ffi, lib as FBInk

    # Let's check which FBInk version we're using...
    # NOTE: ffi.string() returns a bytes on Python 3, not a str, hence the extra decode
    print("Loaded FBInk {}".format(ffi.string(FBInk.fbink_version()).decode("ascii")))

    # Setup the config...
    fbink_cfg = ffi.new("FBInkConfig *")
    fbink_cfg.is_centered = True
    fbink_cfg.is_halfway = True
    fbink_cfg.is_verbose = False
    fbink_cfg.is_flashing = False

    # Abort if we weren't passed a filepath...
    # if len(sys.argv) < 2:
    # 	raise SystemExit("Expected a path to an image file as the first argument!")

    # NOTE: No error checking is done here!
    fbfd = FBInk.fbink_open()
    try:
        FBInk.fbink_init(fbfd, fbink_cfg)


        # im = Image.open(theImage)
        im = theImage
        print("Image mode: {}".format(im.mode))
        print("Image size: {}x{}".format(im.width, im.height))

        # And finally, get that image data as raw packed pixels.
        raw_data = im.tobytes("raw")
        raw_len = len(raw_data)
        print("Raw data buffer length: {}".format(raw_len))

        

        FBInk.fbink_print_raw_data(fbfd, raw_data, im.width, im.height, raw_len, 0, 0, fbink_cfg)
    finally:
        FBInk.fbink_close(fbfd)    
