
from imageUtils import imageCycle
from PIL import Image, ImageDraw, ImageFont
import extraUtils
import kindleStates
from clock import dateTimeClock


verbose = False

FONT_FILE = extraUtils.openFile("Bookerly-Regular.ttf")
WIDGET_FILL = (255,255,255,6*16)
TEXT_FILL = (0,0,0)
STROKE_WIDTH = 2
STROKE_FILL = (255,255,255,160)
STROKE_FILL_INVERT = (0,0,0)


PADDING = 20
FONT_SIZE_DEFAULT = 24


topbarHeight = 0

class Layers:
    def generate_background(imageFile,SETTINGS):

        SCREEN_RESOLUTION = SETTINGS["SCREEN_RESOLUTION"]
        
        layer = Image.open(imageFile).convert("RGBA")
        if verbose: print("Background layer image:",imageFile)
        if not layer.size == SCREEN_RESOLUTION:
            layer.resize(SCREEN_RESOLUTION)
            if verbose: print("Background layer resized")
        return layer

    def gray_scale(imageLayer):
        image = imageLayer.convert("L")
        # image = image.quantize(16)
        return image



class Topbar:
    def generate_topbar(imageLayer,SETTINGS):
        
        SCREEN_RESOLUTION = SETTINGS["SCREEN_RESOLUTION"]
        TOP_BAR_TOGGLE = SETTINGS["TOP_BAR_TOGGLE"]
        TOP_BAR_TEXT = SETTINGS["TOP_BAR_TEXT"]
        TOP_BAR_HOUR = SETTINGS["TOP_BAR_HOUR"]

        global FONT_SIZE_DEFAULT

        if TOP_BAR_TOGGLE == 1:
            image = Image.new('RGBA', SCREEN_RESOLUTION)
            draw = ImageDraw.Draw(image)

            padding = 30

            
            

            widgetHeight = 50 
            widgetRes = (SCREEN_RESOLUTION[0],widgetHeight)
            widgetLoc = (0,0)

            draw.rectangle([widgetLoc,widgetRes], fill=WIDGET_FILL, outline=None, width=0)
            draw.line([(0,widgetRes[1]),widgetRes], fill=(255,255,255,220),  width=2)

            
            if TOP_BAR_TEXT == 0:Topbar.date(draw,widgetRes,widgetLoc,padding)
            elif TOP_BAR_TEXT == 1: Topbar.photoName(draw,imageCycle.imageName(),widgetRes,widgetLoc,padding)

            hourModuleSpacing = Topbar.hour(draw,widgetRes,widgetLoc,padding,TOP_BAR_HOUR)

            Topbar.battery(draw,widgetRes,widgetLoc,padding,hourModuleSpacing)
            
            global topbarHeight
            topbarHeight = widgetHeight
            
            return Image.alpha_composite(imageLayer,image)
        
        return imageLayer

    def photoName(draw,photoName,widgetRes,widgetLoc,padding):
        font = ImageFont.truetype(FONT_FILE, FONT_SIZE_DEFAULT)
        itemLoc = (widgetLoc[0]+padding, widgetLoc[1]+widgetRes[1]/2)
        draw.text(itemLoc, photoName, font=font, fill=TEXT_FILL, stroke_width=STROKE_WIDTH, stroke_fill=STROKE_FILL, anchor="lm")
        
    def date(draw,widgetRes,widgetLoc,padding):
        dayDateMonth = dateTimeClock.dayDateMonth()
        font = ImageFont.truetype(FONT_FILE, FONT_SIZE_DEFAULT)
        itemLoc = (widgetLoc[0]+padding, widgetLoc[1]+widgetRes[1]/2)
        draw.text(itemLoc, dayDateMonth, font=font, fill=TEXT_FILL, stroke_width=STROKE_WIDTH, stroke_fill=STROKE_FILL, anchor="lm") 

    def hour(draw,widgetRes,widgetLoc,padding,TOP_BAR_HOUR):
        if TOP_BAR_HOUR == 0: 
            return padding
        else:
            time12h = dateTimeClock.current_time_12h()
            font = ImageFont.truetype(FONT_FILE, FONT_SIZE_DEFAULT)
            itemLoc = (widgetRes[0]-padding,widgetLoc[1]+widgetRes[1]/2)
            draw.text(itemLoc, time12h, font=font, fill=TEXT_FILL, stroke_width=STROKE_WIDTH, stroke_fill=STROKE_FILL, anchor="rm")
            width = draw.textsize(time12h, font=font)
            width = width[0] - width[1]
            return width + padding + padding*10/6

    def battery(draw,widgetRes,widgetLoc,padding,hourModuleSpace):
        battery = kindleStates.batteryLevel()
        
        fontSize =FONT_SIZE_DEFAULT
        fontSizeOffset = 3
        fontSize -= fontSizeOffset

        font = ImageFont.truetype(FONT_FILE, fontSize)
        battWidth = 34
        battHeight = 22
        battTipWidth = 3
        battTipHeight = 8

        outlineWidth = STROKE_WIDTH

        isCharging = battery.isCharging
        battLevel = battery.level

        battLoc = (widgetRes[0]-battWidth-battTipWidth-hourModuleSpace,widgetLoc[1]+widgetRes[1]/2-battHeight/2)

        # Positioning Adjustment'
        battRes = (battLoc[0]+battWidth-battTipWidth+outlineWidth*4,battLoc[1]+battHeight)
        
        battTipStart = (battRes[0],battRes[1]-battHeight/2-battTipHeight/2)
        battTipEnd = (battTipStart[0]+battTipWidth,battTipStart[1]+battTipHeight)
        
        battLevelInd = (battLoc[0]+outlineWidth*2,battLoc[1]+outlineWidth*2)
        
        battNumLoc = (battLoc[0]-padding/4,widgetLoc[1]/2+widgetRes[1]/2+fontSizeOffset/2)

        # Battery Bar
        draw.rectangle([battTipStart,battTipEnd], fill=STROKE_FILL_INVERT, outline=None, width=0)
        draw.rounded_rectangle(
            [(battLoc[0],battLoc[1]), (battRes[0],battRes[1])], 
            radius=3, fill=STROKE_FILL_INVERT, outline=None, width=0)
        draw.rounded_rectangle(
            [(battLoc[0]+outlineWidth,battLoc[1]+outlineWidth),
            (battRes[0]-outlineWidth,battRes[1]-outlineWidth)], 
            radius=2, fill=STROKE_FILL)


        if not isCharging:
            # Battery level
            battLevelProgress = (battLevel/100)*(battWidth-battTipWidth)
            battLevelRes = (battLevelInd[0]+battLevelProgress,battLoc[1]+battHeight-outlineWidth*2)
            draw.rounded_rectangle([battLevelInd,battLevelRes], radius=1, fill=STROKE_FILL_INVERT, outline=None, width=0)
            draw.text(battNumLoc, str(battLevel)+"%", font=font, fill=TEXT_FILL, stroke_width=outlineWidth, stroke_fill=STROKE_FILL, anchor="rm")

        else:
            width = 4
            gap = -.25

            height = 4
            thickness = 4
            battLevelProgress = (100/100)*(battWidth-battTipWidth)
            battLevelRes = (battLevelInd[0]+battLevelProgress,battLoc[1]+battHeight-outlineWidth*2)

            bolt = (
                battLevelInd[0] + (battLevelRes[0]-battLevelInd[0])/2-(width*5)/2,
                battLevelRes[1]-(battLevelInd[1]/2)+(height/2))
            # Battery level
            draw.rounded_rectangle([battLevelInd,battLevelRes], radius=1, fill=STROKE_FILL_INVERT, outline=None, width=0)
            draw.polygon(
                [
                    (bolt[0]+(width)*0,bolt[1]+height),

                    (bolt[0]+(width+gap)*2,bolt[1]-height),
                    (bolt[0]+(width-gap)*3,bolt[1]+height-thickness),

                    (bolt[0]+(width)*5,bolt[1]-height),

                    (bolt[0]+(width-gap)*3,bolt[1]+height),
                    (bolt[0]+(width+gap)*2,bolt[1]-height+thickness),

                ],
                fill=STROKE_FILL)
            draw.text(battNumLoc, str(battLevel)+"%", font=font, fill=TEXT_FILL, stroke_width=outlineWidth, stroke_fill=STROKE_FILL, anchor="rm")

class WidgetForSchedule:
    def generate_module(imageLayer,SETTINGS):

        # fillWidget = None

        SCREEN_RESOLUTION = SETTINGS["SCREEN_RESOLUTION"]

        TOP_BAR_TOGGLE = SETTINGS["TOP_BAR_TOGGLE"]

        SCHEDULE_CONTENT = SETTINGS["SCHEDULE_CONTENT"]

        base_font_size = SETTINGS["SCHEDULE_FONT_SIZE"]
        
        x_offset = SETTINGS["SCHEDULE_X_OFFSET"]
        y_offset = SETTINGS["SCHEDULE_Y_OFFSET"]

        x_align = SETTINGS["SCHEDULE_X_ALIGN"]
        
        currentTime12h = dateTimeClock.current_time_12h()
        # currentTime12h ="00:00 XY"
        currentTime24h = dateTimeClock.currentTime24h()
        dayDateMonth = dateTimeClock.day_date_month()
        # scheduleList = kindleStates.scheduleList(time_current)

        PADDING = 20
        

        image = Image.new('RGBA', SCREEN_RESOLUTION)
        draw = ImageDraw.Draw(image)


        widgetRes = (SCREEN_RESOLUTION[0]-(PADDING*2),400)
        
        if TOP_BAR_TOGGLE == 0:
            widgetLoc = (PADDING,PADDING)
        else:
            global topbarHeight
            widgetLoc = (PADDING,topbarHeight+PADDING)

        widgetLocEnd = (widgetLoc[0]+widgetRes[0], widgetLoc[1]+widgetRes[1])

        # draw.rectangle([widgetLoc,widgetLocEnd], fill=fillWidget, outline=None, width=0)
        draw.rectangle([widgetLoc,widgetLocEnd], fill=None, outline=None, width=0)

        if SCHEDULE_CONTENT == 2:
            clockData = WidgetForSchedule.time12h(draw,SCREEN_RESOLUTION,widgetLoc,widgetLocEnd,currentTime12h,base_font_size,x_offset,y_offset,x_align)
            WidgetForSchedule.date(draw,widgetLoc,widgetLocEnd,clockData,dayDateMonth,base_font_size)



        return Image.alpha_composite(imageLayer,image)

    def time12h(draw,SCREEN_RESOLUTION,widgetLoc,widgetLocEnd,currentTime12h,base_font_size,x_offset,y_offset,x_align):
        
        # currentTime12h = currentTime12h[:2]

        font = ImageFont.truetype(FONT_FILE, base_font_size)
        fontOutputDimension = draw.textsize(currentTime12h, font=font)

        # moduleLoc = ((widgetLocEnd[0]/2)*.10,widgetLocEnd[1]*.33+PADDING*2)
        # moduleLoc = ((widgetLocEnd[0]*.55)-fontOutputDimension[0]+x_offset,widgetLocEnd[1]*.55+y_offset)
        
        if x_align == 0:
            moduleLoc = (widgetLoc[0]+fontOutputDimension[0]*.125+x_offset,widgetLoc[1]+fontOutputDimension[1]*1.125+y_offset)
        if x_align == 1:
            moduleLoc = ((SCREEN_RESOLUTION[0]*.5)-(fontOutputDimension[0]*.5),widgetLoc[1]+fontOutputDimension[1]*1.125+y_offset)

        draw.text(moduleLoc, currentTime12h, font=font, fill=TEXT_FILL, stroke_width=STROKE_WIDTH, stroke_fill=STROKE_FILL, anchor="ls")
        return  [moduleLoc,fontOutputDimension]
    
    def date(draw,widgetLoc,widgetLocEnd,clockData,dayDateMonth,base_font_size):
        # dayDateMonth="MARCH, 1231231232789789789789789"
        clockLoc = clockData[0]
        clockDimension = clockData[1]
        # fontSize = int(clockDimension[1]*.33,0)
        fontSize = int(round(clockDimension[1]*.33,0))

        # dayDateMonth = dayDateMonth.upper()
        day_date_dimension=draw.textsize(dayDateMonth, font=ImageFont.truetype(FONT_FILE, fontSize))


        while not clockDimension[0] - 20 >= day_date_dimension[0]:
            # print(day_date_dimension)
            fontSize = fontSize-3
            day_date_dimension=draw.textsize(dayDateMonth, font=ImageFont.truetype(FONT_FILE, fontSize))

            

        moduleLoc = (clockLoc[0]+clockDimension[0]*.50,clockLoc[1]+PADDING*1.3)

        font = ImageFont.truetype(FONT_FILE, fontSize)
        
        draw.text(moduleLoc, dayDateMonth, font=font, fill=TEXT_FILL, stroke_width=STROKE_WIDTH, stroke_fill=STROKE_FILL, anchor="mt")


# SETTINGS = {
#     "SCREEN_RESOLUTION":(1072,1448),
#     "SCHEDULE_CONTENT":2,
#     }
# image = Image.open(extraUtils.openFile("photos/Philippines Cebu Temple.png")).convert("RGBA")
# schedule.generateModule(image,SETTINGS)




def display_image(imageLayer):
    try:
        raise ValueError("error for test purpose - remove later")
        # imageToKindleScreen(imageLayer)
    except:
        imageLayer.show()

