from random import randint
import subprocess


def is_device_kindle():
    try:
        subprocess.run(["lipc-get-prop","--","com.lab126.powerd","status"],stdout=subprocess.PIPE, text=True)
        return True
    except:
        return False

IS_KINDLE=is_device_kindle()


def batteryLevel():
    class battery:
        def __init__(self,level,isCharging):
            self.level = level
            self.isCharging = isCharging            

    if IS_KINDLE:
        battLevel = subprocess.run(["lipc-get-prop","--","com.lab126.powerd","battLevel"],stdout=subprocess.PIPE, text=True)
        level = int(battLevel.stdout.strip())
        isCharging = subprocess.run(["lipc-get-prop","--","com.lab126.powerd","isCharging"],stdout=subprocess.PIPE, text=True)
        isCharging = int(isCharging.stdout.strip())
        return battery(level,isCharging)

    else:
        level = randint(0, 100)
        isCharging = randint(0,1)
        return battery(level,isCharging)



def check_screensaver_layer():
    if IS_KINDLE:
        isScreenSaverLayerWindowActive = subprocess.run(["lipc-get-prop","--","com.lab126.winmgr","isScreenSaverLayerWindowActive"],stdout=subprocess.PIPE, text=True)
        isScreenSaverLayerWindowActive = int(isScreenSaverLayerWindowActive.stdout.strip())
        print("Screensaver Layer State:",isScreenSaverLayerWindowActive)
        if isScreenSaverLayerWindowActive == 1: 
            return  1
        elif isScreenSaverLayerWindowActive == 0: 
            return 0     
    else:
        print("isScreenSaverLayerWindowActive set to: 1")
        return 1

def check_power_state():
    if IS_KINDLE:
        power_stateCheck = subprocess.run(["lipc-get-prop","--","com.lab126.powerd","state"],stdout=subprocess.PIPE, text=True)
        power_stateCheck = power_stateCheck.stdout.strip()
        print("power_state: ",power_stateCheck)
        if power_stateCheck == "active": 
            return  1
        elif power_stateCheck == "screenSaver": 
            return 0     
    else:
        print("power_state set to: 1")
        return 1

