import os.path 
import subprocess
import time
import printScreen

def openFile(file):
    DIR = os.path.dirname(os.path.realpath(__file__)) + "/"
    print(DIR)
    if (os.path.exists(DIR+file) == True):
        # root directory in kindle paperwhite 
        print(file,'found in kindle dir')

        print(DIR+file)
        return DIR+file
    else:
        print(file,'not found')



def delay_screensaver_timeout():
    try:
        subprocess.run(["lipc-set-prop","com.lab126.powerd","-i","touchScreenSaverTimeout","1"])
        print("delayScreenSaverTimeout() initiated...")

    except:
        print("delayScreenSaverTimeout() failed...")

######
lightIntensity = 11
lightIntensityNew = 6
checkLightOnce = 0
def adjustLightIntensity(screenLayerState):
    global lightIntensity
    global checkLightOnce
    global lightIntensityNew
    verbose = True

    def getLightIntensity():
        light = subprocess.run(["lipc-get-prop","com.lab126.powerd","flIntensity"],stdout=subprocess.PIPE, text=True)
        lightIntensity = int(light.stdout.strip())
        if verbose:print("lightIntensity:",lightIntensity)
        subprocess.run(["lipc-set-prop","com.lab126.powerd","-i","flIntensity",str(lightIntensityNew)])
        return lightIntensity

    def changeLightIntensity(level):
        subprocess.run(["lipc-set-prop","com.lab126.powerd","-i","flIntensity",str(level)],stdout=subprocess.PIPE, text=True)

    try:
        if verbose:print("adjustLightIntensity() initiated...")
        if(checkLightOnce == 0 and screenLayerState == 1):
            lightIntensity = getLightIntensity()
            if verbose:print("lightIntensity adjusted to",lightIntensityNew)
            checkLightOnce = 1
        elif(checkLightOnce == 1 and screenLayerState == 0 ):
            checkLightOnce = 0
            changeLightIntensity(lightIntensity)
        if verbose: print("Light Intensity:",lightIntensity,"\nlightIntensityNew:",lightIntensityNew)

    except:
        if verbose:print("adjustLightIntensity() failed...")

######
refreshOnce = 0
def refresh_screen_once(ins="",verbose=False):
    global refreshOnce
    if verbose == True:print("refreshOnce:",refreshOnce)   
    
    if ins.lower() == "reset":
        refreshOnce = 0
        if verbose == True:print("checkpower_state() reset")
    elif refreshOnce == 0:
        time.sleep(1)
        printScreen.screenFlash()
        refreshOnce = 1