from datetime import datetime as dt
# import time import sleep
import time

verbose = True
# verbose = False


# iniTime = int(dt.utcnow().timestamp())
time_check = str()
time_current = dt.now()

time_last = str()
time_stamp_current = float(dt.timestamp(time_current))

class Timer:
   # init method
    def __init__(self,time):
        # self
        self.time_stamp_last = float(dt.timestamp(time_current))
        minutes = time[0]
        seconds = time[1]
        self.delay = minutes*60 + seconds
    
    def timer_update(verbose = False):
        global time_current
        global time_stamp_current 
        
        time_current = dt.now()
        time_stamp_current = float(dt.timestamp(time_current))

    def timer_check(self, name, verbose = False):
        global time_stamp_current 

        time_stamp_lastInt = int(self.time_stamp_last)
        currentTimeInt = int(time_stamp_current)
        timeLeft = time_stamp_lastInt + self.delay - currentTimeInt

        if verbose:print(name+":", timeLeft, "seconds left")
        # print(time_stamp_current,self.time_stamp_last + self.delay)
        if time_stamp_current >= self.time_stamp_last + self.delay:
            self.time_stamp_last = time_stamp_current
            if verbose:print("Timer Complete")
            return True
        else: False

    def loop_speed_limiter(milliseconds, verbose = False):
        global time_stamp_current
        cycle_currentTime = float(dt.now().timestamp())

        delay = milliseconds/1000 # convert to milliseconds for time.sleep(...)
        adjustedDelay =  delay - (cycle_currentTime - time_stamp_current)
        
        if verbose:
            if adjustedDelay == delay: 
                print("Adjusted Delay:",adjustedDelay,"seconds - no adjustment needed")
            elif adjustedDelay > 0: 
                print("Adjusted Delay:",adjustedDelay,"seconds")
            elif adjustedDelay == 0: 
                print("Adjusted Delay: 0 seconds - loop is faster than measurable speed")
            else: 
                print("Adjusted Delay: 0 seconds - loop is slower than speed limit")

        # Only execute if loop is faster than min speed (i.e. not negative)
        if adjustedDelay > 0: 
            time.sleep(adjustedDelay)    

        
def timeTo12h(time):
    midday_dt = dt.strptime('12:00','%H:%M')
    time_dt = dt.strptime(time, '%H:%M')

    if time_dt >= dt.strptime('13:00', '%H:%M'):
        hours, minutes = clamp_to_twelve(time_dt, midday_dt)
        time = f'{hours}:{minutes:02d} PM'
    elif time_dt >= midday_dt:
        time += ' NN'
    elif time_dt < dt.strptime('10:00', '%H:%M') and time_dt >= dt.strptime('01:00','%H:%M'):
        time = f'{time[1:]} AM'
    elif is_midnight(time_dt):
        hours, minutes = clamp_to_twelve(time_dt, midday_dt)
        time = f'{hours}:{minutes:02d} MN'
    else:
        time += ' AM'
    return time
def clamp_to_twelve(time_dt, midday_dt):
    clamp_dt = time_dt - midday_dt
    minutes, seconds = divmod(clamp_dt.seconds, 60)
    hours, minutes = divmod(minutes, 60)
    return [hours, minutes]
def is_midnight(time_dt):
    return (time_dt >= dt.strptime('00:00','%H:%M') and
        time_dt <= dt.strptime('00:59','%H:%M'))            

    
class dateTimeClock:
    def current_time_12h():
        time24h = time_current.strftime("%H:%M")
        time12h = timeTo12h(time24h)
        suffix = time_current.strftime("%p")
        hour  = int(time_current.strftime("%I"))
        minute = time_current.strftime("%M")
        return str(hour)+":"+minute+" "+suffix

    def current_time_12h_abr():
        hour  = int(time_current.strftime("%I"))
        minute = time_current.strftime("%M")
        return str(hour)+":"+minute

    def currentTime24h():
        time24h = time_current.strftime("%H:%M")
        return time24h

    def day_date_month():
        day = time_current.strftime('%A')
        date = str(time_current.day)
        month = time_current.strftime('%B')
        dayDateMonth = day+", "+date+" "+month
        return dayDateMonth
    
    def day_date_month_abr():
        day = time_current.strftime('%A')
        date = str(time_current.day)
        month = time_current.strftime('%B')
        dayDateMonth = day[:3]+", "+date+" "+month
        return dayDateMonth

    def yearMonthDay():
        day = str(time_current.day)
        month = str(time_current.month)
        year = str(time_current.year)

        y = year+"/"+month+"/"+day
        return y

# print(dateTimeClock.yearMonthDay())


# print(dateTime.currentTime12h())
# print(dateTime.currentTime24h())
# print(dateTime.dayDateMonth())


