from clock import timer
import layers
import dataProcess

from imageUtils import imageCycle
import printScreen
import extraUtils







# Settings
screenResolution = (1072,1448)
topbarOption = 1 # 0 - Day Date Month, 1 - Photo Name



# Some Variables
## Image
backgroundCurrent = str()
image = object()

## Toggles
stateCheckDelay = 5
stateCheckCounter = 0
screensaverLayerState = 0
powerState = 0


if True:
    backgroundCurrent = imageCycle.ordered()


while True:
    timer.timerUpdate()


    if stateCheckCounter < stateCheckDelay:
        stateCheckCounter += 1
    else:
        screensaverLayerState=dataProcess.checkScreenSaverLayer()
        powerState = dataProcess.checkPowerState()
        stateCheckCounter = 0




    if screensaverLayerState and powerState: 
        
        try:
            # raise # Uncomment for shortened interval - testing purposes
            t1 = timer.timerOneCheck(20,0) # (minute,seconds)
            t2 = timer.timerTwoCheck(1,0)
        except:
            t1 = timer.timerOneCheck(0,20) 
            t2 = timer.timerTwoCheck(0,5)

        if t1 == True: 
            print("\nRunning Task One")
            backgroundCurrent = imageCycle.ordered()
            extraUtils.refreshScreenOnce("Reset")
            print(backgroundCurrent)
                    
        if t2 == True: 
            print("\nRunning Task Two")
            image = layers.layers.generateBackground(backgroundCurrent,screenResolution)
            image = layers.topBar.generateTopbar(image,screenResolution,topbarOption)
            image = layers.layers.grayScale(image)


            try:
                
                extraUtils.delayScreenSaverTimeout()
                # extraUtils.adjustLightIntensity(1)
                printScreen.imageToKindleScreen(image)
                extraUtils.refreshScreenOnce()
            except:
                layers.displayImage(image)
                # break
    else: 
        timer.loopSpeedLimiter(1000)
        extraUtils.refreshScreenOnce("Reset")
        # extraUtils.adjustLightIntensity(0)
    

    
    # break

    timer.loopSpeedLimiter(1000)
    

 
