
from PIL.Image import alpha_composite
from imageUtils import Image, ImageDraw, ImageFont, imageCycle
import extraUtils
import dataProcess
from clock import dateTimeClock

verbose = True
verbose = False

fontFile = extraUtils.openFile("Bookerly-Regular.ttf")
fillWidget = (255,255,255,6*16)
fillText = (0,0,0)
strokeWidth = 2
strokeFill = (255,255,255,160)
fillStrokeInvert = tuple()
if strokeFill[0] >= 127: fillStrokeInvert = (0,0,0)
else: fillStrokeInvert = (255,255,255)

fontSizeDefault = 24

class layers:
    def generateBackground(imageFile,canvasRes):
        
        layer = Image.open(imageFile).convert("RGBA")
        if verbose: print("Background layer image:",imageFile)
        if not layer.size == canvasRes:
            layer.resize(canvasRes)
            if verbose: print("Background layer resized")
        return layer


    def grayScale(imageLayer):
        image = imageLayer.convert("L")
        # image = image.quantize(16)
        return image



class topBar:
    def generateTopbar(imageLayer,canvasRes,code,):
        
        

        global fontSizeDefault
        
        image = Image.new('RGBA', canvasRes)
        draw = ImageDraw.Draw(image)

        padding = 30

        
        font = ImageFont.truetype(fontFile, fontSizeDefault)
        widgetRes = (canvasRes[0],50)
        widgetLoc = (0,0)

        draw.rectangle([widgetLoc,widgetRes], fill=fillWidget, outline=None, width=0)
        draw.line([(0,widgetRes[1]),widgetRes], fill=(255,255,255,220),  width=2)

        
        if code == 0:topBar.date(draw,fontFile,fontSizeDefault,widgetRes,widgetLoc,padding)
        elif code == 1: topBar.photoName(draw,imageCycle.imageName(),fontFile,fontSizeDefault,widgetRes,widgetLoc,padding)

        hourModuleSpace = topBar.hour(draw,fontFile,fontSizeDefault,widgetRes,widgetLoc,padding)
        topBar.battery(draw,fontFile,fontSizeDefault,widgetRes,widgetLoc,padding,hourModuleSpace)
        
        return alpha_composite(imageLayer,image)

    def photoName(draw,photoName,fontFile,fontSize,widgetRes,widgetLoc,padding):
        font = ImageFont.truetype(fontFile, fontSize)
        itemLoc = (widgetLoc[0]+padding, widgetLoc[1]+widgetRes[1]/2)
        draw.text(itemLoc, photoName, font=font, fill=fillText, stroke_width=strokeWidth, stroke_fill=strokeFill, anchor="lm")
        
    def date(draw,fontFile,fontSize,widgetRes,widgetLoc,padding):
        dayDateMonth = dateTimeClock.dayDateMonth()
        font = ImageFont.truetype(fontFile, fontSize)
        itemLoc = (widgetLoc[0]+padding, widgetLoc[1]+widgetRes[1]/2)
        draw.text(itemLoc, dayDateMonth, font=font, fill=fillText, stroke_width=strokeWidth, stroke_fill=strokeFill, anchor="lm")
        

    def hour(draw,fontFile,fontSize,widgetRes,widgetLoc,padding):
        time12h = dateTimeClock.currentTime12h()
        font = ImageFont.truetype(fontFile, fontSize)
        itemLoc = (widgetRes[0]-padding,widgetLoc[1]+widgetRes[1]/2)
        draw.text(itemLoc, time12h, font=font, fill=fillText, stroke_width=strokeWidth, stroke_fill=strokeFill, anchor="rm")
        width = draw.textsize(time12h, font=font)
        width = width[0] - width[1]
        return width + padding

    def battery(draw,fontFile,fontSize,widgetRes,widgetLoc,padding,hourModuleSpace):
        battery = dataProcess.batteryLevel()
        
        fontSizeOffset = 3
        fontSize -= fontSizeOffset

        font = ImageFont.truetype(fontFile, fontSize)
        battWidth = 34
        battHeight = 22
        battTipWidth = 3
        battTipHeight = 8

        outlineWidth = strokeWidth

        isCharging = battery.isCharging
        battLevel = battery.level

        battLoc = (widgetRes[0]-battWidth-battTipWidth-(padding*10/6)-hourModuleSpace,widgetLoc[1]+widgetRes[1]/2-battHeight/2)

        # Possitioning Adjustment
        battRes = (battLoc[0]+battWidth-battTipWidth+outlineWidth*4,battLoc[1]+battHeight)
        
        battTipStart = (battRes[0],battRes[1]-battHeight/2-battTipHeight/2)
        battTipEnd = (battTipStart[0]+battTipWidth,battTipStart[1]+battTipHeight)
        
        battLevelInd = (battLoc[0]+outlineWidth*2,battLoc[1]+outlineWidth*2)
        battLevelProgress = (battLevel/100)*(battWidth-battTipWidth)
        if isCharging: battLevelProgress = (100/100)*(battWidth-battTipWidth)
        battLevelRes = (battLevelInd[0]+battLevelProgress,battLoc[1]+battHeight-outlineWidth*2)

        battNumLoc = (battLoc[0]-padding/4,widgetLoc[1]/2+widgetRes[1]/2+fontSizeOffset/2)

        # Battery Bar
        draw.rectangle([battTipStart,battTipEnd], fill=fillStrokeInvert, outline=None, width=0)
        draw.rounded_rectangle(
            [(battLoc[0],battLoc[1]), (battRes[0],battRes[1])], 
            radius=3, fill=fillStrokeInvert, outline=None, width=0)
        draw.rounded_rectangle(
            [(battLoc[0]+outlineWidth,battLoc[1]+outlineWidth),
            (battRes[0]-outlineWidth,battRes[1]-outlineWidth)], 
            radius=2, fill=strokeFill)

        # Battery level
        draw.rounded_rectangle([battLevelInd,battLevelRes], radius=1, fill=fillStrokeInvert, outline=None, width=0)
        draw.text(battNumLoc, str(battLevel)+"%", font=font, fill=fillText, stroke_width=outlineWidth, stroke_fill=strokeFill, anchor="rm")


        
        if isCharging:
            width = 4
            gap = -.25

            height = 4
            thickness = 4
            bolt = (
                battLevelInd[0] + (battLevelRes[0]-battLevelInd[0])/2-(width*5)/2,
                battLevelRes[1]-(battLevelInd[1]/2)+(height/2))
            draw.polygon(
                [
                    (bolt[0]+(width)*0,bolt[1]+height),

                    (bolt[0]+(width+gap)*2,bolt[1]-height),
                    (bolt[0]+(width-gap)*3,bolt[1]+height-thickness),

                    (bolt[0]+(width)*5,bolt[1]-height),

                    (bolt[0]+(width-gap)*3,bolt[1]+height),
                    (bolt[0]+(width+gap)*2,bolt[1]-height+thickness),

                ],
                fill=strokeFill)
            #, outline=fillStrokeInvert)

    

def displayImage(imageLayer):
    try:
        raise ValueError("error for test purpose - remove later")
        # imageToKindleScreen(imageLayer)
    except:
        imageLayer.show()

