<?php

//Provide info on codec
function lrf_codec_info() {

	//Return the info
	return "\tSony's proprietry BBeB eBook format";
}

//Check Dependencies
function check_deps_lrf() {

	//No Internal Dependecies for lrf, check the external ones
	if (!shell_exec('which html2lrf') && !shell_exec('html2lrf')) printFatalErr('Dependency html2lrf (part of Calibre is missing - is Calibre installed?');
}

//Convert story format to LRF
function convert_story_lrf($story) {

	//Get global references
	global $config;

	//Set up file names
	$fname = 'fflag' . PID . $config['storyid'];
	$temp_fname = TEMP . '/' . $fname;

	//Get the converted HTML story
	file_put_contents("$temp_fname.html", convert_story_html($story));
	
	//Goto to the temp folder
	chdir(TEMP);

	//Create the lrf content and store it in a temp file
	exec("html2lrf -t \"{$story['meta']['title']}\" -a \"{$story['meta']['author']}\" --header --blank-after-para --minimum-indent 32 --publisher \"http://www.fanfiction.net/\" --headerformat \"%t by %a  [#{$config['storyid']}]\" --disable-chapter-detection --force-page-break-before-attr \"div,class,chapter$\" \"$temp_fname.html\"");
	$result = file_get_contents("$temp_fname.lrf");

	//Delete the files used
	unlink("$temp_fname.html");
	unlink("$temp_fname.lrf");

	//Return the result
	return $result;
}

?>