<?php

///gets CLI args and returns them as an associative array
function getCliArgs() {
	global $argc, $argv;
	$path = array_shift($argv);
	$url = array();
	if($argc <= 1) printHelp($path);
	while($item = array_shift($argv)) {
		switch($item) {
			case '--help':
			case '-h':
				printHelp($path);
				break;
			case '--story':
			case '-i':
				$arr['storyid'] = array_shift($argv);
				break;
			case '--source':
			case '-s':
				$arr['source'] = array_shift($argv);
				break;
			case '--format':
			case '-f':
				$arr['format'] = array_shift($argv);
				break;
			case '--notoc':
				$arr['notoc'] = true;
				break;
			case '--outfile':
			case '-o':
				$arr['outfile'] = array_shift($argv);
				break;
			default:
				printErr("$item is not a vaild argument!");
				break;
		}
	}
	if(!isset($arr['source'])) {//printErr('You must specify a source!');
		$arr['source'] = 'ffnet';
		file_put_contents('php://stderr', "\t! No source specified - using default (ffnet)\n");
	}
	else {
		if(!file_exists("source/{$arr['source']}.source.php")) {
			printErr("{$arr['source']} is not a valid source!");
		}
		switch($arr['source']) {
			case 'ffnet':
				if(!isset($arr['storyid'])) printErr('You must specify a story id!');
				break;
		}
	}
	if(!isset($arr['format'])) {
		$arr['format'] = 'lrf';
		file_put_contents('php://stderr', "\t! No output format specified - using default (lrf)\n");
	}
	if(!file_exists("codec/{$arr['format']}.codec.php")) printErr("Invalid format - you do not have a codec installed for type '{$arr['format']}'!");
	return $arr;
}

///prints an error to STDERR and quits
function printErr($errmsg) {
	$fh = fopen('php://stderr', 'w');
	fwrite($fh, "\007$errmsg\nPlease see --help for usage information.\n");
	fclose($fh);
	die(1);
}

///prints the CLI help to STDERR
function printHelp($path, $errmsg = null) {
if($errmsg != null) echo("\007$errmsg\n");
$helptext = <<<eot
Usage: {$path} [options] --source SOURCE [--outfile OUTPUT_FILE]
Options:
	--help    -h	Show this help
	--source  -s	Data source
	--story   -i	story ID (ffnet only)
	--format  -f	Output data format
	--outfile -o	Output filename, use '-' for autonaming
	--notoc		Don't generate a table of contents
	
eot;
	
	$helptext .= "\nValid sources (ffnet is the default):\n";
	$arr = getInstalledSources();
	foreach($arr as $name => $desc) $helptext .= "\t$name\t$desc\n";
	
	$helptext .= "\nValid output formats:\n";
	$arr = getInstalledCodecs();
	foreach($arr as $name => $desc) $helptext .= "\t$name\t$desc\n";

	$fh = fopen('php://stderr', 'w');
	fwrite($fh, "\007$helptext\n");
	fclose($fh);
	die(1);
}

function getInstalledCodecs() {
	$dh = opendir('codec');
	while($name = readdir($dh)) {
		$qr = preg_match('/^(.+)\.codec.php$/Ui', $name, $matches);
		if($qr) {
			include("codec/{$matches[1]}.codec.php");
			$func_name = "$matches[1]_codec_info";
			$arr[$matches[1]] = $func_name();
		}
	}
	return $arr;
}

function getInstalledSources() {
	$dh = opendir('source');
	while($name = readdir($dh)) {
		$qr = preg_match('/^(.+)\.source.php$/Ui', $name, $matches);
		if($qr) {
			include("source/{$matches[1]}.source.php");
			$func_name = "$matches[1]_source_info";
			$arr[$matches[1]] = $func_name();
		}
	}
	return $arr;
}


?>