<?php

///provide information on codec
function epub_codec_info() {
	return "\tOpen ebook format based on xml / zip";
}

///check dependencies
function check_deps_epub() {
	//there are no internal dependencies for lrf, so only check external ones
	if(!shell_exec('which html2epub')) printFatalErr('Dependency html2epub (part of Calibre) is missing - is Calibre installed?');
}

///convert story format to HTML
function convert_story_epub($story) {
	global $config;
	$fname = 'fflag' . PID . $config['storyid'];
	file_put_contents("/tmp/$fname.html", convert_story_html($story));
	chdir('/tmp');
	exec("html2epub -t \"{$story['meta']['title']}\" -a \"{$story['meta']['author']}\" --publisher \"http://www.fanfiction.net/\" \"/tmp/$fname.html\"");
	$result = file_get_contents("/tmp/$fname.epub");
	unlink("/tmp/$fname.html");
	unlink("/tmp/$fname.epub");
	return $result;
}

?>