#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2008, Darko Miletic <darko.miletic at gmail.com>'
'''
pagina12.com.ar
'''

from calibre.web.feeds.news import BasicNewsRecipe

class Pagina12(BasicNewsRecipe):
    title                 = u'Pagina/12'
    __author__            = u'Darko Miletic'
    description           = u'Noticias de Argentina'    
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = False
    encoding = 'cp1252'
    
    remove_tags = [
                     dict(name='span' , attrs={'id':'seccion'     })
                    ,dict(name='div'  , attrs={'id':'logo'        })
                    ,dict(name='div'  , attrs={'id':'volver'      })
                    ,dict(name='div'  , attrs={'id':'fin'         })
                    ,dict(name='span' , attrs={'class':'separador'})
                  ]
    
    feeds = [(u'Pagina/12', u'http://www.pagina12.com.ar/diario/rss/principal.xml')]

    def print_version(self, url):
        return url.replace('http://www.pagina12.com.ar/','http://www.pagina12.com.ar/imprimir/')
                     