# -*- coding: utf-8 -*-
from __future__ import absolute_import
import re
import six
__license__ = 'GPL 3'
__copyright__ = '2013, Saulius P. <saulius@kofmarai.net>'
__docformat__ = 'restructuredtext en'

from calibre_plugins.hyphenatethis.gui.config import DICT_ZIP
from calibre.utils.zipfile import ZipFile
from calibre.ptempfile import PersistentTemporaryFile

HYP_REGEX_LEFT_MIN = 'LEFTHYPHENMIN\s([0-9])'
HYP_REGEX_RIGHT_MIN = 'RIGHTHYPHENMIN\s([0-9])'

def get_dict_by_lang(l):
    with ZipFile(DICT_ZIP) as z:
        for d in z.namelist():
            if six.text_type(d.split('.')[0]) == l:
                f = PersistentTemporaryFile()
                f.write(z.read(d))
                return f.name
    return None

def get_dict_left_righ_min(path):
    from calibre_plugins.hyphenatethis.gui.config import prefs
    try:
        dct = open(path).read(64)
    except:
        dct = open(path, encoding="latin-1").read(64)
    regl = re.compile(HYP_REGEX_LEFT_MIN)
    regr = re.compile(HYP_REGEX_RIGHT_MIN)
    try:
        lmin = int(regl.search(dct).group(1))
    except:
        lmin = 2
    try:
        rmin = int(regr.search(dct).group(1))
    except:
        rmin = 2
    return (lmin, rmin)